/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.actuate.autoconfigure.metrics.web.bes;

import com.bes.enterprise.webtier.Manager;
import io.micrometer.core.instrument.FunctionCounter;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.TimeGauge;
import io.micrometer.core.instrument.binder.MeterBinder;
import io.micrometer.core.lang.NonNullApi;
import io.micrometer.core.lang.NonNullFields;
import io.micrometer.core.lang.Nullable;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanServer;
import javax.management.MBeanServerDelegate;
import javax.management.MBeanServerFactory;
import javax.management.MBeanServerNotification;
import javax.management.MalformedObjectNameException;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;

@NonNullApi
@NonNullFields
public class BesMetrics
implements MeterBinder {
    private final MBeanServer mBeanServer;
    private final Iterable<Tag> tags;
    @Nullable
    private final Manager manager;

    public BesMetrics(@Nullable Manager manager, Iterable<Tag> tags) {
        this(manager, tags, BesMetrics.getMBeanServer());
    }

    public BesMetrics(@Nullable Manager manager, Iterable<Tag> tags, MBeanServer mBeanServer) {
        this.tags = tags;
        this.manager = manager;
        this.mBeanServer = mBeanServer;
    }

    public static void monitor(MeterRegistry registry, @Nullable Manager manager, String ... tags) {
        BesMetrics.monitor(registry, manager, (Iterable<Tag>)Tags.of((String[])tags));
    }

    public static void monitor(MeterRegistry registry, @Nullable Manager manager, Iterable<Tag> tags) {
        new BesMetrics(manager, tags).bindTo(registry);
    }

    public static MBeanServer getMBeanServer() {
        ArrayList<MBeanServer> mBeanServers = MBeanServerFactory.findMBeanServer(null);
        return !mBeanServers.isEmpty() ? (MBeanServer)mBeanServers.get(0) : ManagementFactory.getPlatformMBeanServer();
    }

    public void bindTo(MeterRegistry reg) {
        this.registerGlobalRequestMetrics(reg);
        this.registerServletMetrics(reg);
        this.registerCacheMetrics(reg);
        this.registerThreadPoolMetrics(reg);
        if (this.manager != null) {
            Gauge.builder((String)"bes.sessions.active.max", (Object)this.manager, Manager::getMaxActive).tags(this.tags).register(reg);
            Gauge.builder((String)"bes.sessions.active.current", (Object)this.manager, Manager::getActiveSessions).tags(this.tags).register(reg);
            FunctionCounter.builder((String)"bes.sessions.created", (Object)this.manager, Manager::getSessionCounter).tags(this.tags).register(reg);
            FunctionCounter.builder((String)"bes.sessions.expired", (Object)this.manager, Manager::getExpiredSessions).tags(this.tags).register(reg);
            FunctionCounter.builder((String)"bes.sessions.rejected", (Object)this.manager, Manager::getRejectedSessions).tags(this.tags).register(reg);
            TimeGauge.builder((String)"bes.sessions.alive.max.second", (Object)this.manager, (TimeUnit)TimeUnit.SECONDS, Manager::getSessionMaxAliveTime).tags(this.tags).register(reg);
        }
    }

    private void registerThreadPoolMetrics(MeterRegistry registry) {
        this.registerMetricsEventually("type", "ThreadPool", (name, allTags) -> {
            Gauge.builder((String)"bes.threads.busy", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "currentThreadsBusy"))).tags(allTags).register(registry);
            Gauge.builder((String)"bes.threads.current", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "currentThreadCount"))).tags(allTags).register(registry);
            Gauge.builder((String)"bes.connections.max", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxConnections"))).tags(allTags).register(registry);
            Gauge.builder((String)"bes.connections.current", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "connectionCount"))).tags(allTags).register(registry);
            Gauge.builder((String)"bes.accept.count", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "acceptCount"))).tags(allTags).register(registry);
        });
        this.registerMetricsEventually("type", "Executor", (name, allTags) -> Gauge.builder((String)"bes.threads.config.max", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxThreads"))).tags(allTags).register(registry));
    }

    private void registerCacheMetrics(MeterRegistry registry) {
        this.registerMetricsEventually("type", "StringCache", (name, allTags) -> {
            FunctionCounter.builder((String)"bes.cache.access", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "accessCount"))).tags(allTags).register(registry);
            FunctionCounter.builder((String)"bes.cache.hit", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "hitCount"))).tags(allTags).register(registry);
        });
    }

    private void registerServletMetrics(MeterRegistry registry) {
        this.registerMetricsEventually("j2eeType", "Servlet", (name, allTags) -> {
            FunctionCounter.builder((String)"bes.servlet.error", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "errorCount"))).tags(allTags).register(registry);
            FunctionTimer.builder((String)"bes.servlet.request", (Object)this.mBeanServer, s -> this.safeLong(() -> s.getAttribute((ObjectName)name, "requestCount")), s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "processingTime")), (TimeUnit)TimeUnit.MILLISECONDS).tags(allTags).register(registry);
            TimeGauge.builder((String)"bes.servlet.request.max", (Object)this.mBeanServer, (TimeUnit)TimeUnit.MILLISECONDS, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxTime"))).tags(allTags).register(registry);
        });
    }

    private void registerGlobalRequestMetrics(MeterRegistry registry) {
        this.registerMetricsEventually("type", "GlobalRequestProcessor", (name, allTags) -> {
            FunctionCounter.builder((String)"bes.global.sent", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "bytesSent"))).tags(allTags).baseUnit("bytes").register(registry);
            FunctionCounter.builder((String)"bes.global.received", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "bytesReceived"))).tags(allTags).baseUnit("bytes").register(registry);
            FunctionCounter.builder((String)"bes.global.error", (Object)this.mBeanServer, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "errorCount"))).tags(allTags).register(registry);
            FunctionTimer.builder((String)"bes.global.request", (Object)this.mBeanServer, s -> this.safeLong(() -> s.getAttribute((ObjectName)name, "requestCount")), s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "processingTime")), (TimeUnit)TimeUnit.MILLISECONDS).tags(allTags).register(registry);
            TimeGauge.builder((String)"bes.global.request.max", (Object)this.mBeanServer, (TimeUnit)TimeUnit.MILLISECONDS, s -> this.safeDouble(() -> s.getAttribute((ObjectName)name, "maxTime"))).tags(allTags).register(registry);
        });
    }

    private void registerMetricsEventually(String key, String value, BiConsumer<ObjectName, Iterable<Tag>> perObject) {
        try {
            Set<ObjectName> objs = this.mBeanServer.queryNames(new ObjectName("BES:" + key + "=" + value + ",*"), null);
            if (!objs.isEmpty()) {
                objs.forEach(o -> perObject.accept((ObjectName)o, (Iterable<Tag>)Tags.concat(this.tags, this.nameTag((ObjectName)o))));
                return;
            }
        }
        catch (MalformedObjectNameException var8) {
            throw new RuntimeException("Error registering Bes JMX based metrics", var8);
        }
        NotificationListener notificationListener = (notification, handback) -> {
            MBeanServerNotification mbs = (MBeanServerNotification)notification;
            ObjectName obj = mbs.getMBeanName();
            perObject.accept(obj, (Iterable<Tag>)Tags.concat(this.tags, this.nameTag(obj)));
        };
        NotificationFilter filter = notification -> {
            if (!"JMX.mbean.registered".equals(notification.getType())) {
                return false;
            }
            ObjectName obj = ((MBeanServerNotification)notification).getMBeanName();
            return obj.getDomain().equals("Bes") && obj.getKeyProperty(key).equals(value);
        };
        try {
            this.mBeanServer.addNotificationListener(MBeanServerDelegate.DELEGATE_NAME, notificationListener, filter, null);
        }
        catch (InstanceNotFoundException var7) {
            throw new RuntimeException("Error registering MBean listener", var7);
        }
    }

    private double safeDouble(Callable<Object> callable) {
        try {
            return Double.parseDouble(callable.call().toString());
        }
        catch (Exception var3) {
            return 0.0;
        }
    }

    private long safeLong(Callable<Object> callable) {
        try {
            return Long.parseLong(callable.call().toString());
        }
        catch (Exception var3) {
            return 0L;
        }
    }

    private Iterable<Tag> nameTag(ObjectName name) {
        return name.getKeyProperty("name") != null ? Tags.of((String)"name", (String)name.getKeyProperty("name").replaceAll("\"", "")) : Collections.emptyList();
    }
}

