/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.actuate.autoconfigure.metrics.web.bes;

import com.bes.enterprise.springboot.actuate.autoconfigure.metrics.web.bes.BesMetrics;
import com.bes.enterprise.springboot.actuate.autoconfigure.metrics.web.bes.InfoExtensionContributor;
import com.bes.enterprise.springboot.embedded.BesContextCustomizer;
import com.bes.enterprise.springboot.embedded.BesServletWebServerFactory;
import com.bes.enterprise.webtier.Context;
import com.bes.enterprise.webtier.Manager;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;

@ConditionalOnWebApplication
@ConditionalOnClass(value={BesMetrics.class, Manager.class})
public class BesMetricsAutoConfiguration {
    private volatile Context context;

    @Bean
    @ConditionalOnMissingBean(value={BesMetrics.class})
    public BesMetrics besMetrics(ApplicationContext applicationContext) {
        return new BesMetrics(this.context == null ? null : this.context.getManager(), Collections.emptyList());
    }

    @Bean
    @ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
    public WebServerFactoryCustomizer<BesServletWebServerFactory> contextCapturingServletBesCustomizer() {
        return besFactory -> besFactory.addContextCustomizers(new BesContextCustomizer[]{this::setContext});
    }

    @Bean
    public InfoExtensionContributor infoExtensionContributor() {
        return new InfoExtensionContributor();
    }

    private void setContext(Context context) {
        this.context = context;
    }
}

