/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.springboot.actuate.autoconfigure.metrics.web.bes;

import io.prometheus.client.CollectorRegistry;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.boot.actuate.metrics.export.prometheus.PrometheusScrapeEndpoint;

@WebEndpoint(id="prometheus")
public class BesPrometheusScrapeEndpoint
extends PrometheusScrapeEndpoint {
    private volatile String cache = null;
    private volatile long expiry = System.currentTimeMillis();
    private final CollectorRegistry collectorRegistry;
    private Long timeout;
    private Lock lock = new ReentrantLock();

    public BesPrometheusScrapeEndpoint(CollectorRegistry collectorRegistry, Long timeout) {
        super(collectorRegistry);
        this.collectorRegistry = collectorRegistry;
        this.timeout = timeout;
    }

    @ReadOperation(produces={"text/plain; version=0.0.4; charset=utf-8"})
    public String scrape() {
        if (this.timeout > 0L) {
            return this.scrapeWithCache();
        }
        return super.scrape();
    }

    public boolean isExpired(long now) {
        return now >= this.expiry;
    }

    private String scrapeWithCache() {
        String metric = this.cache;
        if (metric != null) {
            if (!this.isExpired(System.currentTimeMillis())) {
                return metric;
            }
            this.cache = null;
        }
        this.lock.lock();
        try {
            metric = this.cache;
            if (metric != null) {
                String string = metric;
                return string;
            }
            this.cache = metric = super.scrape();
            this.expiry = System.currentTimeMillis() + this.timeout;
            String string = metric;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

