/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.asn1.cmc;

import com.bes.enterprise.cipher.asn1.ASN1EncodableVector;
import com.bes.enterprise.cipher.asn1.ASN1Object;
import com.bes.enterprise.cipher.asn1.ASN1Primitive;
import com.bes.enterprise.cipher.asn1.ASN1Sequence;
import com.bes.enterprise.cipher.asn1.DERSequence;
import com.bes.enterprise.cipher.asn1.DERUTF8String;
import com.bes.enterprise.cipher.asn1.cmc.BodyPartID;
import com.bes.enterprise.cipher.asn1.cmc.CMCStatus;
import com.bes.enterprise.cipher.asn1.cmc.OtherStatusInfo;
import com.bes.enterprise.cipher.asn1.cmc.Utils;

public class CMCStatusInfoV2
extends ASN1Object {
    private final CMCStatus cMCStatus;
    private final ASN1Sequence bodyList;
    private final DERUTF8String statusString;
    private final OtherStatusInfo otherStatusInfo;

    CMCStatusInfoV2(CMCStatus cMCStatus, ASN1Sequence bodyList, DERUTF8String statusString, OtherStatusInfo otherStatusInfo) {
        this.cMCStatus = cMCStatus;
        this.bodyList = bodyList;
        this.statusString = statusString;
        this.otherStatusInfo = otherStatusInfo;
    }

    private CMCStatusInfoV2(ASN1Sequence seq) {
        if (seq.size() < 2 || seq.size() > 4) {
            throw new IllegalArgumentException("incorrect sequence size");
        }
        this.cMCStatus = CMCStatus.getInstance(seq.getObjectAt(0));
        this.bodyList = ASN1Sequence.getInstance(seq.getObjectAt(1));
        if (seq.size() > 2) {
            if (seq.size() == 4) {
                this.statusString = DERUTF8String.getInstance(seq.getObjectAt(2));
                this.otherStatusInfo = OtherStatusInfo.getInstance(seq.getObjectAt(3));
            } else if (seq.getObjectAt(2) instanceof DERUTF8String) {
                this.statusString = DERUTF8String.getInstance(seq.getObjectAt(2));
                this.otherStatusInfo = null;
            } else {
                this.statusString = null;
                this.otherStatusInfo = OtherStatusInfo.getInstance(seq.getObjectAt(2));
            }
        } else {
            this.statusString = null;
            this.otherStatusInfo = null;
        }
    }

    public CMCStatus getcMCStatus() {
        return this.cMCStatus;
    }

    public BodyPartID[] getBodyList() {
        return Utils.toBodyPartIDArray(this.bodyList);
    }

    public DERUTF8String getStatusString() {
        return this.statusString;
    }

    public OtherStatusInfo getOtherStatusInfo() {
        return this.otherStatusInfo;
    }

    public boolean hasOtherInfo() {
        return this.otherStatusInfo != null;
    }

    public static CMCStatusInfoV2 getInstance(Object o) {
        if (o instanceof CMCStatusInfoV2) {
            return (CMCStatusInfoV2)o;
        }
        if (o != null) {
            return new CMCStatusInfoV2(ASN1Sequence.getInstance(o));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add(this.cMCStatus);
        v.add(this.bodyList);
        if (this.statusString != null) {
            v.add(this.statusString);
        }
        if (this.otherStatusInfo != null) {
            v.add(this.otherStatusInfo);
        }
        return new DERSequence(v);
    }
}

