/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.generators;

import com.bes.enterprise.cipher.crypto.AsymmetricCipherKeyPair;
import com.bes.enterprise.cipher.crypto.AsymmetricCipherKeyPairGenerator;
import com.bes.enterprise.cipher.crypto.KeyGenerationParameters;
import com.bes.enterprise.cipher.crypto.generators.DHKeyGeneratorHelper;
import com.bes.enterprise.cipher.crypto.params.DHKeyGenerationParameters;
import com.bes.enterprise.cipher.crypto.params.DHParameters;
import com.bes.enterprise.cipher.crypto.params.DHPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.DHPublicKeyParameters;
import java.math.BigInteger;

public class DHKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DHKeyGenerationParameters param;

    @Override
    public void init(KeyGenerationParameters param) {
        this.param = (DHKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        DHKeyGeneratorHelper helper = DHKeyGeneratorHelper.INSTANCE;
        DHParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DHPublicKeyParameters(y, dhp), new DHPrivateKeyParameters(x, dhp));
    }
}

