/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.prng.drbg;

import com.bes.enterprise.cipher.math.ec.ECPoint;

public class DualECPoints {
    private final ECPoint p;
    private final ECPoint q;
    private final int securityStrength;
    private final int cofactor;

    public DualECPoints(int securityStrength, ECPoint p, ECPoint q, int cofactor) {
        if (!p.getCurve().equals(q.getCurve())) {
            throw new IllegalArgumentException("points need to be on the same curve");
        }
        this.securityStrength = securityStrength;
        this.p = p;
        this.q = q;
        this.cofactor = cofactor;
    }

    public int getSeedLen() {
        return this.p.getCurve().getFieldSize();
    }

    public int getMaxOutlen() {
        return (this.p.getCurve().getFieldSize() - (13 + DualECPoints.log2(this.cofactor))) / 8 * 8;
    }

    public ECPoint getP() {
        return this.p;
    }

    public ECPoint getQ() {
        return this.q;
    }

    public int getSecurityStrength() {
        return this.securityStrength;
    }

    public int getCofactor() {
        return this.cofactor;
    }

    private static int log2(int value) {
        int log = 0;
        while ((value >>= 1) != 0) {
            ++log;
        }
        return log;
    }
}

