/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.tls;

import com.bes.enterprise.cipher.crypto.DSA;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.ECPublicKeyParameters;
import com.bes.enterprise.cipher.crypto.signers.ECDSASigner;
import com.bes.enterprise.cipher.crypto.signers.HMacDSAKCalculator;
import com.bes.enterprise.cipher.crypto.tls.TlsDSASigner;
import com.bes.enterprise.cipher.crypto.tls.TlsUtils;

public class TlsECDSASigner
extends TlsDSASigner {
    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof ECPublicKeyParameters;
    }

    @Override
    protected DSA createDSAImpl(short hashAlgorithm) {
        return new ECDSASigner(new HMacDSAKCalculator(TlsUtils.createHash(hashAlgorithm)));
    }

    @Override
    protected short getSignatureAlgorithm() {
        return 3;
    }
}

