/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.crypto.tls;

import com.bes.enterprise.cipher.crypto.AsymmetricBlockCipher;
import com.bes.enterprise.cipher.crypto.CipherParameters;
import com.bes.enterprise.cipher.crypto.CryptoException;
import com.bes.enterprise.cipher.crypto.Digest;
import com.bes.enterprise.cipher.crypto.Signer;
import com.bes.enterprise.cipher.crypto.digests.NullDigest;
import com.bes.enterprise.cipher.crypto.encodings.PKCS1Encoding;
import com.bes.enterprise.cipher.crypto.engines.RSABlindedEngine;
import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.ParametersWithRandom;
import com.bes.enterprise.cipher.crypto.params.RSAKeyParameters;
import com.bes.enterprise.cipher.crypto.signers.GenericSigner;
import com.bes.enterprise.cipher.crypto.signers.RSADigestSigner;
import com.bes.enterprise.cipher.crypto.tls.AbstractTlsSigner;
import com.bes.enterprise.cipher.crypto.tls.CombinedHash;
import com.bes.enterprise.cipher.crypto.tls.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.crypto.tls.TlsUtils;

public class TlsRSASigner
extends AbstractTlsSigner {
    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        return signer.generateSignature();
    }

    @Override
    public boolean verifyRawSignature(SignatureAndHashAlgorithm algorithm, byte[] sigBytes, AsymmetricKeyParameter publicKey, byte[] hash) throws CryptoException {
        Signer signer = this.makeSigner(algorithm, true, false, publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(sigBytes);
    }

    @Override
    public Signer createSigner(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter privateKey) {
        return this.makeSigner(algorithm, false, true, new ParametersWithRandom(privateKey, this.context.getSecureRandom()));
    }

    @Override
    public Signer createVerifyer(SignatureAndHashAlgorithm algorithm, AsymmetricKeyParameter publicKey) {
        return this.makeSigner(algorithm, false, false, publicKey);
    }

    @Override
    public boolean isValidPublicKey(AsymmetricKeyParameter publicKey) {
        return publicKey instanceof RSAKeyParameters && !publicKey.isPrivate();
    }

    protected Signer makeSigner(SignatureAndHashAlgorithm algorithm, boolean raw, boolean forSigning, CipherParameters cp) {
        if (algorithm != null != TlsUtils.isTLSv12(this.context)) {
            throw new IllegalStateException();
        }
        if (algorithm != null && algorithm.getSignature() != 1) {
            throw new IllegalStateException();
        }
        Digest d = raw ? new NullDigest() : (algorithm == null ? new CombinedHash() : TlsUtils.createHash(algorithm.getHash()));
        Signer s = algorithm != null ? new RSADigestSigner(d, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash())) : new GenericSigner(this.createRSAImpl(), d);
        s.init(forSigning, cp);
        return s;
    }

    protected AsymmetricBlockCipher createRSAImpl() {
        return new PKCS1Encoding(new RSABlindedEngine());
    }
}

