/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

import com.bes.enterprise.cipher.gmssl.AbstractTlsClient;
import com.bes.enterprise.cipher.gmssl.DefaultTlsDHConfigVerifier;
import com.bes.enterprise.cipher.gmssl.DefaultTlsKeyExchangeFactory;
import com.bes.enterprise.cipher.gmssl.TlsDHConfigVerifier;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchange;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchangeFactory;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCrypto;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;

public abstract class DefaultTlsClient
extends AbstractTlsClient {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52393, 49195, 49187, 49161, 52392, 49199, 49191, 49171, 52394, 158, 103, 51, 156, 60, 47, 57363};
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected int[] supportedCipherSuites;

    public DefaultTlsClient(TlsCrypto crypto) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsDHConfigVerifier());
    }

    public DefaultTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsDHConfigVerifier dhConfigVerifier) {
        super(crypto, keyExchangeFactory);
        this.dhConfigVerifier = dhConfigVerifier;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    @Override
    public int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(keyExchangeAlgorithm);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(keyExchangeAlgorithm);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(keyExchangeAlgorithm);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(keyExchangeAlgorithm);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
            case 25: {
                return this.createSM2KeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createDHKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.dhConfigVerifier);
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createDHEKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.dhConfigVerifier);
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createECDHKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.createECConfigVerifier(), this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createECDHEKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.createECConfigVerifier(), this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() throws IOException {
        return this.keyExchangeFactory.createRSAKeyExchange(this.supportedSignatureAlgorithms);
    }

    protected TlsKeyExchange createSM2KeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createSM2KeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.createECConfigVerifier(), this.clientECPointFormats, this.serverECPointFormats);
    }
}

