/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

import com.bes.enterprise.cipher.gmssl.AbstractTlsServer;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedDecryptor;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedSigner;
import com.bes.enterprise.cipher.gmssl.TlsCredentials;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchange;
import com.bes.enterprise.cipher.gmssl.TlsKeyExchangeFactory;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCrypto;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;

public abstract class DefaultTlsServer
extends AbstractTlsServer {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52392, 49200, 49199, 49192, 49191, 49172, 49171, 52394, 159, 158, 107, 103, 57, 51, 157, 156, 61, 60, 53, 47, 57363};
    protected int[] supportedCipherSuites;

    public DefaultTlsServer(TlsCrypto crypto) {
        super(crypto);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    public DefaultTlsServer(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory) {
        super(crypto, keyExchangeFactory);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    protected TlsCredentialedSigner getDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getECDSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsCredentialedSigner getRSASignerCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 3: {
                return this.getDSASignerCredentials();
            }
            case 11: 
            case 20: {
                return null;
            }
            case 17: {
                return this.getECDSASignerCredentials();
            }
            case 5: 
            case 19: {
                return this.getRSASignerCredentials();
            }
            case 1: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int keyExchangeAlgorithm = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (keyExchangeAlgorithm) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(keyExchangeAlgorithm);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(keyExchangeAlgorithm);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(keyExchangeAlgorithm);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(keyExchangeAlgorithm);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
            case 25: {
                return this.createSM2KeyExchange(keyExchangeAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createDHKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectDHConfig());
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createDHEKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectDHConfig());
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createECDHKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectECConfig(), this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createECDHEKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectECConfig(), this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() throws IOException {
        return this.keyExchangeFactory.createRSAKeyExchange(this.supportedSignatureAlgorithms);
    }

    protected TlsKeyExchange createSM2KeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createSM2KeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.selectECConfig(), this.serverECPointFormats);
    }
}

