/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.DigestInputBuffer;
import com.bes.enterprise.cipher.gmssl.DigitallySigned;
import com.bes.enterprise.cipher.gmssl.TlsCredentialedSigner;
import com.bes.enterprise.cipher.gmssl.TlsCredentials;
import com.bes.enterprise.cipher.gmssl.TlsECConfigVerifier;
import com.bes.enterprise.cipher.gmssl.TlsECDHKeyExchange;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsRSAUtils;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsECConfig;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.gmssl.crypto.TlsVerifier;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.GMSSLSignerAndDecryptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class GMSM2KeyExchange
extends TlsECDHKeyExchange {
    protected GMSSLSignerAndDecryptor serverCredentials = null;
    protected Certificate serverCertificate = null;
    protected TlsVerifier verifier = null;
    protected TlsSecret preMasterSecret;

    private static int checkKeyExchange(int keyExchange) {
        switch (keyExchange) {
            case 25: {
                return keyExchange;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public GMSM2KeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(GMSM2KeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms, ecConfigVerifier, clientECPointFormats, serverECPointFormats);
    }

    public GMSM2KeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfig ecConfig, short[] serverECPointFormats) {
        super(GMSM2KeyExchange.checkKeyExchange(keyExchange), supportedSignatureAlgorithms, ecConfig, serverECPointFormats);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (GMSSLSignerAndDecryptor)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.verifier = serverCertificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
        this.serverCertificate = serverCertificate;
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        DigestInputBuffer buf = new DigestInputBuffer();
        DigitallySigned signedParams = TlsUtils.generateGMServerKeyExchangeSignature(this.context, this.serverCredentials, buf);
        signedParams.encode(this.context, buf);
        return buf.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        DigestInputBuffer buf = new DigestInputBuffer();
        DigitallySigned signedParams = this.parseSignature(input);
        TlsUtils.verifyGMServerKeyExchangeSignature(this.context, this.serverCertificate, this.verifier, buf, signedParams);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{1, 64, 80};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        TlsCertificate encryptCert = this.serverCertificate.getCertificateAt(1);
        this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, encryptCert, output);
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] encryptedPreMasterSecret = TlsUtils.readOpaque16(input);
        this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), encryptedPreMasterSecret);
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        if (this.preMasterSecret != null) {
            return this.preMasterSecret;
        }
        throw new TlsFatalAlert(80);
    }
}

