/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl;

public class NamedGroup {
    public static final int sect163k1 = 1;
    public static final int sect163r1 = 2;
    public static final int sect163r2 = 3;
    public static final int sect193r1 = 4;
    public static final int sect193r2 = 5;
    public static final int sect233k1 = 6;
    public static final int sect233r1 = 7;
    public static final int sect239k1 = 8;
    public static final int sect283k1 = 9;
    public static final int sect283r1 = 10;
    public static final int sect409k1 = 11;
    public static final int sect409r1 = 12;
    public static final int sect571k1 = 13;
    public static final int sect571r1 = 14;
    public static final int secp160k1 = 15;
    public static final int secp160r1 = 16;
    public static final int secp160r2 = 17;
    public static final int secp192k1 = 18;
    public static final int secp192r1 = 19;
    public static final int secp224k1 = 20;
    public static final int secp224r1 = 21;
    public static final int secp256k1 = 22;
    public static final int secp256r1 = 23;
    public static final int secp384r1 = 24;
    public static final int secp521r1 = 25;
    public static final int brainpoolP256r1 = 26;
    public static final int brainpoolP384r1 = 27;
    public static final int brainpoolP512r1 = 28;
    public static final int ffdhe2048 = 256;
    public static final int ffdhe3072 = 257;
    public static final int ffdhe4096 = 258;
    public static final int ffdhe6144 = 259;
    public static final int ffdhe8192 = 260;
    public static final int arbitrary_explicit_prime_curves = 65281;
    public static final int arbitrary_explicit_char2_curves = 65282;
    private static final String[] CURVE_NAMES = new String[]{"sect163k1", "sect163r1", "sect163r2", "sect193r1", "sect193r2", "sect233k1", "sect233r1", "sect239k1", "sect283k1", "sect283r1", "sect409k1", "sect409r1", "sect571k1", "sect571r1", "secp160k1", "secp160r1", "secp160r2", "secp192k1", "secp192r1", "secp224k1", "secp224r1", "secp256k1", "secp256r1", "secp384r1", "secp521r1", "brainpoolp256r1", "brainpoolp384r1", "brainpoolp512r1"};
    private static final String[] FINITE_FIELD_NAMES = new String[]{"ffdhe2048", "ffdhe3072", "ffdhe4096", "ffdhe6144", "ffdhe8192"};

    public static int getByName(String name) {
        if (name != null) {
            int i;
            for (i = 0; i < CURVE_NAMES.length; ++i) {
                if (!name.equals(CURVE_NAMES[i])) continue;
                return 1 + i;
            }
            for (i = 0; i < FINITE_FIELD_NAMES.length; ++i) {
                if (!name.equals(FINITE_FIELD_NAMES[i])) continue;
                return 256 + i;
            }
        }
        return -1;
    }

    public static int getCurveBits(int namedGroup) {
        switch (namedGroup) {
            case 15: 
            case 16: 
            case 17: {
                return 160;
            }
            case 1: 
            case 2: 
            case 3: {
                return 163;
            }
            case 18: 
            case 19: {
                return 192;
            }
            case 4: 
            case 5: {
                return 193;
            }
            case 20: 
            case 21: {
                return 224;
            }
            case 6: 
            case 7: {
                return 233;
            }
            case 8: {
                return 239;
            }
            case 22: 
            case 23: 
            case 26: {
                return 256;
            }
            case 9: 
            case 10: {
                return 283;
            }
            case 24: 
            case 27: {
                return 384;
            }
            case 11: 
            case 12: {
                return 409;
            }
            case 28: {
                return 512;
            }
            case 25: {
                return 521;
            }
            case 13: 
            case 14: {
                return 571;
            }
        }
        return 0;
    }

    public static int getFiniteFieldBits(int namedGroup) {
        switch (namedGroup) {
            case 256: {
                return 2048;
            }
            case 257: {
                return 3072;
            }
            case 258: {
                return 4096;
            }
            case 259: {
                return 6144;
            }
            case 260: {
                return 8192;
            }
        }
        return 0;
    }

    public static int getMaximumChar2CurveBits() {
        return 571;
    }

    public static int getMaximumCurveBits() {
        return 571;
    }

    public static int getMaximumFiniteFieldBits() {
        return 8192;
    }

    public static int getMaximumPrimeCurveBits() {
        return 521;
    }

    public static String getName(int namedGroup) {
        if ((namedGroup & 0xFFFFFF00) == 65024) {
            return "PRIVATE";
        }
        if (namedGroup >= 1 && namedGroup <= 28) {
            return CURVE_NAMES[namedGroup - 1];
        }
        if (namedGroup >= 256 && namedGroup <= 260) {
            return FINITE_FIELD_NAMES[namedGroup - 256];
        }
        switch (namedGroup) {
            case 65281: {
                return "arbitrary_explicit_prime_curves";
            }
            case 65282: {
                return "arbitrary_explicit_char2_curves";
            }
        }
        return "UNKNOWN";
    }

    public static String getText(int namedGroup) {
        return NamedGroup.getName(namedGroup) + "(" + namedGroup + ")";
    }

    public static boolean isChar2Curve(int namedGroup) {
        return namedGroup >= 1 && namedGroup <= 14 || namedGroup == 65282;
    }

    public static boolean isPrimeCurve(int namedGroup) {
        return namedGroup >= 15 && namedGroup <= 28 || namedGroup == 65281;
    }

    public static boolean isPrivate(int namedGroup) {
        return (namedGroup & 0xFFFFFF00) == 65024;
    }

    public static boolean isValid(int namedGroup) {
        return NamedGroup.refersToASpecificGroup(namedGroup) || NamedGroup.isPrivate(namedGroup) || namedGroup >= 65281 && namedGroup <= 65282;
    }

    public static boolean refersToASpecificCurve(int namedGroup) {
        return namedGroup >= 1 && namedGroup <= 28;
    }

    public static boolean refersToASpecificFiniteField(int namedGroup) {
        return namedGroup >= 256 && namedGroup <= 260;
    }

    public static boolean refersToASpecificGroup(int namedGroup) {
        return namedGroup >= 1 && namedGroup <= 28 || namedGroup >= 256 && namedGroup <= 260;
    }
}

