/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl;

import com.bes.enterprise.cipher.gmssl.crypto.TlsCertificate;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCipher;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.gmssl.crypto.impl.AbstractTlsCrypto;
import com.bes.enterprise.cipher.util.Arrays;
import java.io.IOException;

public abstract class AbstractTlsSecret
implements TlsSecret {
    protected byte[] data;

    protected AbstractTlsSecret(byte[] data) {
        this.data = data;
    }

    protected void checkAlive() {
        if (this.data == null) {
            throw new IllegalStateException("Secret has already been extracted or destroyed");
        }
    }

    protected abstract AbstractTlsCrypto getCrypto();

    @Override
    public TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        return this.getCrypto().createCipher(cryptoParams, encryptionAlgorithm, macAlgorithm);
    }

    @Override
    public synchronized void destroy() {
        if (this.data != null) {
            Arrays.fill(this.data, (byte)0);
            this.data = null;
        }
    }

    @Override
    public synchronized byte[] encrypt(TlsCertificate certificate) throws IOException {
        this.checkAlive();
        return this.getCrypto().createEncryptor(certificate).encrypt(this.data, 0, this.data.length);
    }

    @Override
    public synchronized byte[] extract() {
        this.checkAlive();
        byte[] result = this.data;
        this.data = null;
        return result;
    }

    synchronized byte[] copyData() {
        return Arrays.clone(this.data);
    }
}

