/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl;

import com.bes.enterprise.cipher.gmssl.ProtocolVersion;
import com.bes.enterprise.cipher.gmssl.SecurityParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSecret;
import com.bes.enterprise.cipher.util.Arrays;

public class TlsImplUtils {
    public static boolean isGMSSLv11(ProtocolVersion version) {
        return ProtocolVersion.GMSSLv11.equals(version);
    }

    public static boolean isGMSSLv11(TlsCryptoParameters cryptoParams) {
        return TlsImplUtils.isGMSSLv11(cryptoParams.getServerVersion());
    }

    public static byte[] calculateKeyBlock(TlsCryptoParameters cryptoParams, int length) {
        SecurityParameters securityParameters = cryptoParams.getSecurityParameters();
        TlsSecret master_secret = securityParameters.getMasterSecret();
        byte[] seed = Arrays.concatenate(securityParameters.getServerRandom(), securityParameters.getClientRandom());
        return TlsImplUtils.PRF(cryptoParams, master_secret, "key expansion", seed, length).extract();
    }

    public static TlsSecret PRF(TlsCryptoParameters cryptoParams, TlsSecret secret, String asciiLabel, byte[] seed, int length) {
        int prfAlgorithm = cryptoParams.getSecurityParameters().getPrfAlgorithm();
        return secret.deriveUsingPRF(prfAlgorithm, asciiLabel, seed, length);
    }
}

