/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.bc;

import com.bes.enterprise.cipher.crypto.params.AsymmetricKeyParameter;
import com.bes.enterprise.cipher.crypto.params.DSAPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.ECPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.RSAKeyParameters;
import com.bes.enterprise.cipher.gmssl.Certificate;
import com.bes.enterprise.cipher.gmssl.DefaultTlsCredentialedSigner;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.crypto.TlsCryptoParameters;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsDSASigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsECDSASigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsRSASigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsSigner;

public class BcDefaultTlsCredentialedSigner
extends DefaultTlsCredentialedSigner {
    private static TlsSigner makeSigner(BcTlsCrypto crypto, AsymmetricKeyParameter privateKey) {
        BcTlsSigner signer;
        if (privateKey instanceof RSAKeyParameters) {
            signer = new BcTlsRSASigner(crypto, (RSAKeyParameters)privateKey);
        } else if (privateKey instanceof DSAPrivateKeyParameters) {
            signer = new BcTlsDSASigner(crypto, (DSAPrivateKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            signer = new BcTlsECDSASigner(crypto, (ECPrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
        return signer;
    }

    public BcDefaultTlsCredentialedSigner(TlsCryptoParameters cryptoParams, BcTlsCrypto crypto, AsymmetricKeyParameter privateKey, Certificate certificate, SignatureAndHashAlgorithm signatureAndHashAlgorithm) {
        super(cryptoParams, BcDefaultTlsCredentialedSigner.makeSigner(crypto, privateKey), certificate, signatureAndHashAlgorithm);
    }
}

