/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.bc;

import com.bes.enterprise.cipher.crypto.CryptoException;
import com.bes.enterprise.cipher.crypto.Digest;
import com.bes.enterprise.cipher.crypto.Signer;
import com.bes.enterprise.cipher.crypto.encodings.PKCS1Encoding;
import com.bes.enterprise.cipher.crypto.engines.RSABlindedEngine;
import com.bes.enterprise.cipher.crypto.params.ParametersWithRandom;
import com.bes.enterprise.cipher.crypto.params.RSAKeyParameters;
import com.bes.enterprise.cipher.crypto.signers.GenericSigner;
import com.bes.enterprise.cipher.crypto.signers.RSADigestSigner;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsSigner;
import java.io.IOException;

public class BcTlsRSASigner
extends BcTlsSigner {
    public BcTlsRSASigner(BcTlsCrypto crypto, RSAKeyParameters privateKey) {
        super(crypto, privateKey);
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        Signer signer;
        Digest nullDigest = this.crypto.createDigest((short)0);
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException();
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(true, new ParametersWithRandom(this.privateKey, this.crypto.getSecureRandom()));
        signer.update(hash, 0, hash.length);
        try {
            return signer.generateSignature();
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }
}

