/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.bc;

import com.bes.enterprise.cipher.crypto.Digest;
import com.bes.enterprise.cipher.crypto.Signer;
import com.bes.enterprise.cipher.crypto.encodings.PKCS1Encoding;
import com.bes.enterprise.cipher.crypto.engines.RSABlindedEngine;
import com.bes.enterprise.cipher.crypto.params.RSAKeyParameters;
import com.bes.enterprise.cipher.crypto.signers.GenericSigner;
import com.bes.enterprise.cipher.crypto.signers.RSADigestSigner;
import com.bes.enterprise.cipher.gmssl.DigitallySigned;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.bc.BcTlsVerifier;

public class BcTlsRSAVerifier
extends BcTlsVerifier {
    public BcTlsRSAVerifier(BcTlsCrypto crypto, RSAKeyParameters publicKey) {
        super(crypto, publicKey);
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        Signer signer;
        Digest nullDigest = this.crypto.createDigest((short)0);
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null) {
            if (algorithm.getSignature() != 1) {
                throw new IllegalStateException();
            }
            signer = new RSADigestSigner(nullDigest, TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()));
        } else {
            signer = new GenericSigner(new PKCS1Encoding(new RSABlindedEngine()), nullDigest);
        }
        signer.init(false, this.publicKey);
        signer.update(hash, 0, hash.length);
        return signer.verifySignature(signedParams.getSignature());
    }
}

