/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSigner;
import com.bes.enterprise.cipher.gmssl.crypto.TlsStreamSigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsCrypto;
import com.bes.enterprise.cipher.jcajce.spec.SM2ParameterSpec;
import com.bes.enterprise.cipher.util.Strings;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;

public class JcaGMSSLSigner
implements TlsSigner {
    private final JcaTlsCrypto crypto;
    private final PrivateKey privateKey;
    private final short algorithmType = (short)4;
    private final String algorithmName = "SM3WITHSM2";

    public JcaGMSSLSigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        this.crypto = crypto;
        this.privateKey = privateKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            Signature signer = this.crypto.getHelper().createSignature("SM3WITHSM2");
            signer.setParameter(new SM2ParameterSpec(Strings.toByteArray("1234567812345678")));
            signer.initSign(this.privateKey);
            signer.update(hash, 0, hash.length);
            return signer.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) {
        return null;
    }
}

