/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.DigitallySigned;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.crypto.TlsStreamVerifier;
import com.bes.enterprise.cipher.gmssl.crypto.TlsVerifier;
import com.bes.enterprise.cipher.jcajce.util.JcaJceHelper;
import java.security.GeneralSecurityException;
import java.security.Signature;
import java.security.interfaces.ECPublicKey;

public class JcaTlsECDSAVerifier
implements TlsVerifier {
    private final JcaJceHelper helper;
    private final ECPublicKey pubKey;

    protected JcaTlsECDSAVerifier(ECPublicKey pubKey, JcaJceHelper helper) {
        if (pubKey == null) {
            throw new IllegalArgumentException("'pubKey' cannot be null");
        }
        this.pubKey = pubKey;
        this.helper = helper;
    }

    @Override
    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) {
        return null;
    }

    @Override
    public boolean verifyRawSignature(DigitallySigned signedParams, byte[] hash) {
        SignatureAndHashAlgorithm algorithm = signedParams.getAlgorithm();
        if (algorithm != null && algorithm.getSignature() != 3) {
            throw new IllegalStateException();
        }
        try {
            Signature signer = this.helper.createSignature("NoneWithECDSA");
            signer.initVerify(this.pubKey);
            if (algorithm == null) {
                signer.update(hash, 16, 20);
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.verify(signedParams.getSignature());
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException("unable to process signature: " + e.getMessage(), e);
        }
    }
}

