/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.asn1.DERNull;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.asn1.x509.DigestInfo;
import com.bes.enterprise.cipher.gmssl.SignatureAndHashAlgorithm;
import com.bes.enterprise.cipher.gmssl.TlsFatalAlert;
import com.bes.enterprise.cipher.gmssl.TlsUtils;
import com.bes.enterprise.cipher.gmssl.crypto.TlsSigner;
import com.bes.enterprise.cipher.gmssl.crypto.TlsStreamSigner;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaTlsCrypto;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.JcaUtils;
import com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce.SignatureOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;

public class JcaTlsRSASigner
implements TlsSigner {
    private final PrivateKey privateKey;
    private final JcaTlsCrypto crypto;
    private Signature rawSigner = null;

    public JcaTlsRSASigner(JcaTlsCrypto crypto, PrivateKey privateKey) {
        this.crypto = crypto;
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        this.privateKey = privateKey;
    }

    @Override
    public byte[] generateRawSignature(SignatureAndHashAlgorithm algorithm, byte[] hash) throws IOException {
        try {
            Signature signer = this.getRawSigner();
            if (algorithm != null) {
                if (algorithm.getSignature() != 1) {
                    throw new IllegalStateException();
                }
                AlgorithmIdentifier algID = new AlgorithmIdentifier(TlsUtils.getOIDForHashAlgorithm(algorithm.getHash()), DERNull.INSTANCE);
                byte[] digestInfo = new DigestInfo(algID, hash).getEncoded();
                signer.update(digestInfo, 0, digestInfo.length);
            } else {
                signer.update(hash, 0, hash.length);
            }
            return signer.sign();
        }
        catch (GeneralSecurityException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
    }

    @Override
    public TlsStreamSigner getStreamSigner(SignatureAndHashAlgorithm algorithm) throws IOException {
        if (algorithm != null && algorithm.getSignature() == 1 && JcaUtils.isSunMSCAPIProviderActive()) {
            try {
                Signature rawSigner = this.getRawSigner();
                if (JcaUtils.isSunMSCAPIProvider(rawSigner.getProvider())) {
                    String algorithmName = JcaUtils.getJcaAlgorithmName(algorithm);
                    final Signature signer = this.crypto.getHelper().createSignature(algorithmName);
                    signer.initSign(this.privateKey, this.crypto.getSecureRandom());
                    return new TlsStreamSigner(){

                        @Override
                        public OutputStream getOutputStream() {
                            return new SignatureOutputStream(signer);
                        }

                        @Override
                        public byte[] getSignature() throws IOException {
                            try {
                                return signer.sign();
                            }
                            catch (SignatureException e) {
                                throw new TlsFatalAlert(80, (Throwable)e);
                            }
                        }
                    };
                }
            }
            catch (GeneralSecurityException e) {
                throw new TlsFatalAlert(80, (Throwable)e);
            }
        }
        return null;
    }

    protected Signature getRawSigner() throws GeneralSecurityException {
        if (this.rawSigner == null) {
            this.rawSigner = this.crypto.getHelper().createSignature("NoneWithRSA");
            this.rawSigner.initSign(this.privateKey, this.crypto.getSecureRandom());
        }
        return this.rawSigner;
    }
}

