/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.crypto.impl.TlsBlockCipherImpl;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JceBlockCipherImpl
implements TlsBlockCipherImpl {
    private final int cipherMode;
    private final Cipher cipher;
    private final String algorithm;
    private SecretKey key;

    public JceBlockCipherImpl(Cipher cipher, String algorithm, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = algorithm;
        this.cipherMode = isEncrypting ? 1 : 2;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    @Override
    public void init(byte[] iv, int ivOff, int ivLen) {
        try {
            this.cipher.init(this.cipherMode, (Key)this.key, new IvParameterSpec(iv, ivOff, ivLen));
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        try {
            return this.cipher.doFinal(input, inputOffset, inputLength, output, outputOffset);
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

