/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.crypto.impl.TlsBlockCipherImpl;
import com.bes.enterprise.cipher.util.Arrays;
import java.security.GeneralSecurityException;
import java.security.Key;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class JceBlockCipherWithCBCImplicitIVImpl
implements TlsBlockCipherImpl {
    private final Cipher cipher;
    private final String algorithm;
    private final boolean isEncrypting;
    private SecretKey key;
    private byte[] nextIV;

    public JceBlockCipherWithCBCImplicitIVImpl(Cipher cipher, String algorithm, boolean isEncrypting) throws GeneralSecurityException {
        this.cipher = cipher;
        this.algorithm = algorithm;
        this.isEncrypting = isEncrypting;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        this.key = new SecretKeySpec(key, keyOff, keyLen, this.algorithm);
    }

    @Override
    public void init(byte[] iv, int ivOff, int ivLen) {
        if (this.nextIV != null) {
            throw new IllegalStateException("unexpected reinitialization of an implicit-IV cipher");
        }
        this.nextIV = Arrays.copyOfRange(iv, ivOff, ivOff + ivLen);
    }

    @Override
    public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
        try {
            this.cipher.init(this.isEncrypting ? 1 : 2, (Key)this.key, new IvParameterSpec(this.nextIV));
            this.nextIV = null;
            if (!this.isEncrypting) {
                this.nextIV = Arrays.copyOfRange(input, inputOffset + inputLength - this.cipher.getBlockSize(), inputOffset + inputLength);
            }
            int len = this.cipher.doFinal(input, inputOffset, inputLength, output, outputOffset);
            if (this.isEncrypting) {
                this.nextIV = Arrays.copyOfRange(output, outputOffset + inputLength - this.cipher.getBlockSize(), outputOffset + inputLength);
            }
            return len;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public int getBlockSize() {
        return this.cipher.getBlockSize();
    }
}

