/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.gmssl.crypto.impl.jcajce;

import com.bes.enterprise.cipher.gmssl.crypto.TlsMAC;
import java.security.InvalidKeyException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class JceTlsMAC
implements TlsMAC {
    private final String algorithm;
    private Mac mac;

    public JceTlsMAC(Mac mac, String algorithm) {
        this.mac = mac;
        this.algorithm = algorithm;
    }

    @Override
    public void setKey(byte[] key, int keyOff, int keyLen) {
        try {
            this.mac.init(new SecretKeySpec(key, keyOff, keyLen, this.algorithm));
        }
        catch (InvalidKeyException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public void update(byte[] input, int inOff, int length) {
        this.mac.update(input, inOff, length);
    }

    @Override
    public byte[] calculateMAC() {
        return this.mac.doFinal();
    }

    @Override
    public int getMacLength() {
        return this.mac.getMacLength();
    }

    @Override
    public void reset() {
        this.mac.reset();
    }
}

