/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce;

import com.bes.enterprise.cipher.crypto.CharToByteConverter;
import com.bes.enterprise.cipher.jcajce.PBKDFKey;
import com.bes.enterprise.cipher.util.Arrays;

public class PBKDF2Key
implements PBKDFKey {
    private final char[] password;
    private final CharToByteConverter converter;

    public PBKDF2Key(char[] password, CharToByteConverter converter) {
        this.password = Arrays.clone(password);
        this.converter = converter;
    }

    public char[] getPassword() {
        return this.password;
    }

    @Override
    public String getAlgorithm() {
        return "PBKDF2";
    }

    @Override
    public String getFormat() {
        return this.converter.getType();
    }

    @Override
    public byte[] getEncoded() {
        return this.converter.convert(this.password);
    }
}

