/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh;

import com.bes.enterprise.cipher.crypto.AsymmetricCipherKeyPair;
import com.bes.enterprise.cipher.crypto.CryptoServicesRegistrar;
import com.bes.enterprise.cipher.crypto.generators.DHBasicKeyPairGenerator;
import com.bes.enterprise.cipher.crypto.generators.DHParametersGenerator;
import com.bes.enterprise.cipher.crypto.params.DHKeyGenerationParameters;
import com.bes.enterprise.cipher.crypto.params.DHParameters;
import com.bes.enterprise.cipher.crypto.params.DHPrivateKeyParameters;
import com.bes.enterprise.cipher.crypto.params.DHPublicKeyParameters;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.BCDHPrivateKey;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.dh.BCDHPublicKey;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.util.PrimeCertaintyCalculator;
import com.bes.enterprise.cipher.jcajce.spec.DHDomainParameterSpec;
import com.bes.enterprise.cipher.jce.provider.BouncyCastleProvider;
import com.bes.enterprise.cipher.util.Integers;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Hashtable;
import javax.crypto.spec.DHParameterSpec;

public class KeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Hashtable params = new Hashtable();
    private static Object lock = new Object();
    DHKeyGenerationParameters param;
    DHBasicKeyPairGenerator engine = new DHBasicKeyPairGenerator();
    int strength = 2048;
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public KeyPairGeneratorSpi() {
        super("DH");
    }

    @Override
    public void initialize(int strength, SecureRandom random) {
        this.strength = strength;
        this.random = random;
        this.initialised = false;
    }

    @Override
    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (!(params instanceof DHParameterSpec)) {
            throw new InvalidAlgorithmParameterException("parameter object not a DHParameterSpec");
        }
        DHParameterSpec dhParams = (DHParameterSpec)params;
        try {
            this.param = this.convertParams(random, dhParams);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidAlgorithmParameterException(e.getMessage(), e);
        }
        this.engine.init(this.param);
        this.initialised = true;
    }

    private DHKeyGenerationParameters convertParams(SecureRandom random, DHParameterSpec dhParams) {
        if (dhParams instanceof DHDomainParameterSpec) {
            return new DHKeyGenerationParameters(random, ((DHDomainParameterSpec)dhParams).getDomainParameters());
        }
        return new DHKeyGenerationParameters(random, new DHParameters(dhParams.getP(), dhParams.getG(), null, dhParams.getL()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            Integer paramStrength = Integers.valueOf(this.strength);
            if (params.containsKey(paramStrength)) {
                this.param = (DHKeyGenerationParameters)params.get(paramStrength);
            } else {
                DHParameterSpec dhParams = BouncyCastleProvider.CONFIGURATION.getDHDefaultParameters(this.strength);
                if (dhParams != null) {
                    this.param = this.convertParams(this.random, dhParams);
                } else {
                    Object object = lock;
                    synchronized (object) {
                        if (params.containsKey(paramStrength)) {
                            this.param = (DHKeyGenerationParameters)params.get(paramStrength);
                        } else {
                            DHParametersGenerator pGen = new DHParametersGenerator();
                            pGen.init(this.strength, PrimeCertaintyCalculator.getDefaultCertainty(this.strength), this.random);
                            this.param = new DHKeyGenerationParameters(this.random, pGen.generateParameters());
                            params.put(paramStrength, this.param);
                        }
                    }
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        DHPublicKeyParameters pub = (DHPublicKeyParameters)pair.getPublic();
        DHPrivateKeyParameters priv = (DHPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCDHPublicKey(pub), new BCDHPrivateKey(priv));
    }
}

