/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.symmetric;

import com.bes.enterprise.cipher.crypto.BlockCipher;
import com.bes.enterprise.cipher.crypto.CipherKeyGenerator;
import com.bes.enterprise.cipher.crypto.engines.CAST6Engine;
import com.bes.enterprise.cipher.crypto.generators.Poly1305KeyGenerator;
import com.bes.enterprise.cipher.crypto.macs.GMac;
import com.bes.enterprise.cipher.crypto.modes.GCMBlockCipher;
import com.bes.enterprise.cipher.jcajce.provider.config.ConfigurableProvider;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseMac;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BlockCipherProvider;

public final class CAST6 {
    private CAST6() {
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = CAST6.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.CAST6", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.CAST6", PREFIX + "$KeyGen");
            this.addGMacAlgorithm(provider, "CAST6", PREFIX + "$GMAC", PREFIX + "$KeyGen");
            this.addPoly1305Algorithm(provider, "CAST6", PREFIX + "$Poly1305", PREFIX + "$Poly1305KeyGen");
        }
    }

    public static class Poly1305KeyGen
    extends BaseKeyGenerator {
        public Poly1305KeyGen() {
            super("Poly1305-CAST6", 256, new Poly1305KeyGenerator());
        }
    }

    public static class Poly1305
    extends BaseMac {
        public Poly1305() {
            super(new com.bes.enterprise.cipher.crypto.macs.Poly1305(new CAST6Engine()));
        }
    }

    public static class GMAC
    extends BaseMac {
        public GMAC() {
            super(new GMac(new GCMBlockCipher(new CAST6Engine())));
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("CAST6", 256, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                @Override
                public BlockCipher get() {
                    return new CAST6Engine();
                }
            });
        }
    }
}

