/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.symmetric;

import com.bes.enterprise.cipher.asn1.misc.MiscObjectIdentifiers;
import com.bes.enterprise.cipher.crypto.PasswordConverter;
import com.bes.enterprise.cipher.crypto.generators.SCrypt;
import com.bes.enterprise.cipher.crypto.params.KeyParameter;
import com.bes.enterprise.cipher.jcajce.provider.config.ConfigurableProvider;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BCPBEKey;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseSecretKeyFactory;
import com.bes.enterprise.cipher.jcajce.provider.util.AlgorithmProvider;
import com.bes.enterprise.cipher.jcajce.spec.ScryptKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import javax.crypto.SecretKey;

public class SCRYPT {
    private SCRYPT() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = SCRYPT.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("SecretKeyFactory.SCRYPT", PREFIX + "$ScryptWithUTF8");
            provider.addAlgorithm("SecretKeyFactory", MiscObjectIdentifiers.id_scrypt, PREFIX + "$ScryptWithUTF8");
        }
    }

    public static class ScryptWithUTF8
    extends BasePBKDF2 {
        public ScryptWithUTF8() {
            super("SCRYPT", 5);
        }
    }

    public static class BasePBKDF2
    extends BaseSecretKeyFactory {
        private int scheme;

        public BasePBKDF2(String name, int scheme) {
            super(name, MiscObjectIdentifiers.id_scrypt);
            this.scheme = scheme;
        }

        @Override
        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof ScryptKeySpec) {
                ScryptKeySpec pbeSpec = (ScryptKeySpec)keySpec;
                if (pbeSpec.getSalt() == null) {
                    throw new IllegalArgumentException("Salt S must be provided.");
                }
                if (pbeSpec.getCostParameter() <= 1) {
                    throw new IllegalArgumentException("Cost parameter N must be > 1.");
                }
                if (pbeSpec.getKeyLength() <= 0) {
                    throw new InvalidKeySpecException("positive key length required: " + pbeSpec.getKeyLength());
                }
                if (pbeSpec.getPassword().length == 0) {
                    throw new IllegalArgumentException("password empty");
                }
                KeyParameter param = new KeyParameter(SCrypt.generate(PasswordConverter.UTF8.convert(pbeSpec.getPassword()), pbeSpec.getSalt(), pbeSpec.getCostParameter(), pbeSpec.getBlockSize(), pbeSpec.getParallelizationParameter(), pbeSpec.getKeyLength() / 8));
                return new BCPBEKey(this.algName, pbeSpec, param);
            }
            throw new InvalidKeySpecException("Invalid KeySpec");
        }
    }
}

