/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.provider.symmetric;

import com.bes.enterprise.cipher.crypto.CipherKeyGenerator;
import com.bes.enterprise.cipher.crypto.engines.TEAEngine;
import com.bes.enterprise.cipher.jcajce.provider.config.ConfigurableProvider;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseBlockCipher;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.BaseKeyGenerator;
import com.bes.enterprise.cipher.jcajce.provider.symmetric.util.IvAlgorithmParameters;
import com.bes.enterprise.cipher.jcajce.provider.util.AlgorithmProvider;

public final class TEA {
    private TEA() {
    }

    public static class Mappings
    extends AlgorithmProvider {
        private static final String PREFIX = TEA.class.getName();

        @Override
        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("Cipher.TEA", PREFIX + "$ECB");
            provider.addAlgorithm("KeyGenerator.TEA", PREFIX + "$KeyGen");
            provider.addAlgorithm("AlgorithmParameters.TEA", PREFIX + "$AlgParams");
        }
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        @Override
        protected String engineToString() {
            return "TEA IV";
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("TEA", 128, new CipherKeyGenerator());
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new TEAEngine());
        }
    }
}

