/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jcajce.util;

import com.bes.enterprise.cipher.jcajce.provider.digest.SM3;
import com.bes.enterprise.cipher.jcajce.util.JcaJceHelper;
import com.bes.enterprise.gmssl.GMCertificateFactory;
import com.bes.enterprise.gmssl.GMCipher;
import com.bes.enterprise.gmssl.GMMac;
import com.bes.enterprise.gmssl.GMSignatureSpi;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.KeyFactory;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;

public class DefaultJcaJceHelper
implements JcaJceHelper {
    private static final String SM3WITHSM2_ALG_ALIAS = "1.2.156.10197.1.501";

    @Override
    public Cipher createCipher(String algorithm) throws NoSuchAlgorithmException, NoSuchPaddingException {
        if (algorithm.equals("SM4/CBC/NOPadding")) {
            return GMCipher.getInstance();
        }
        return Cipher.getInstance(algorithm);
    }

    @Override
    public Mac createMac(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm.equals("HmacSM3")) {
            return GMMac.getInstance();
        }
        return Mac.getInstance(algorithm);
    }

    @Override
    public KeyAgreement createKeyAgreement(String algorithm) throws NoSuchAlgorithmException {
        return KeyAgreement.getInstance(algorithm);
    }

    @Override
    public AlgorithmParameterGenerator createAlgorithmParameterGenerator(String algorithm) throws NoSuchAlgorithmException {
        return AlgorithmParameterGenerator.getInstance(algorithm);
    }

    @Override
    public AlgorithmParameters createAlgorithmParameters(String algorithm) throws NoSuchAlgorithmException {
        return AlgorithmParameters.getInstance(algorithm);
    }

    @Override
    public KeyGenerator createKeyGenerator(String algorithm) throws NoSuchAlgorithmException {
        return KeyGenerator.getInstance(algorithm);
    }

    @Override
    public KeyFactory createKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return KeyFactory.getInstance(algorithm);
    }

    @Override
    public SecretKeyFactory createSecretKeyFactory(String algorithm) throws NoSuchAlgorithmException {
        return SecretKeyFactory.getInstance(algorithm);
    }

    @Override
    public KeyPairGenerator createKeyPairGenerator(String algorithm) throws NoSuchAlgorithmException {
        return KeyPairGenerator.getInstance(algorithm);
    }

    @Override
    public MessageDigest createDigest(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm.equals("SM3")) {
            return new SM3.Digest();
        }
        return MessageDigest.getInstance(algorithm);
    }

    @Override
    public Signature createSignature(String algorithm) throws NoSuchAlgorithmException {
        if (algorithm.equals("SM3WITHSM2") || algorithm.equals(SM3WITHSM2_ALG_ALIAS)) {
            return new GMSignatureSpi.GMSignature(new GMSignatureSpi());
        }
        return Signature.getInstance(algorithm);
    }

    @Override
    public CertificateFactory createCertificateFactory(String algorithm) throws CertificateException {
        if (algorithm.equals("X.509")) {
            return GMCertificateFactory.getInstance();
        }
        return CertificateFactory.getInstance(algorithm);
    }

    @Override
    public SecureRandom createSecureRandom(String algorithm) throws NoSuchAlgorithmException {
        return SecureRandom.getInstance(algorithm);
    }
}

