/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jce.provider;

import com.bes.enterprise.cipher.asn1.ASN1Integer;
import com.bes.enterprise.cipher.asn1.oiw.ElGamalParameter;
import com.bes.enterprise.cipher.asn1.oiw.OIWObjectIdentifiers;
import com.bes.enterprise.cipher.asn1.x509.AlgorithmIdentifier;
import com.bes.enterprise.cipher.asn1.x509.SubjectPublicKeyInfo;
import com.bes.enterprise.cipher.crypto.params.ElGamalPublicKeyParameters;
import com.bes.enterprise.cipher.jcajce.provider.asymmetric.util.KeyUtil;
import com.bes.enterprise.cipher.jce.interfaces.ElGamalPublicKey;
import com.bes.enterprise.cipher.jce.spec.ElGamalParameterSpec;
import com.bes.enterprise.cipher.jce.spec.ElGamalPublicKeySpec;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class JCEElGamalPublicKey
implements ElGamalPublicKey,
DHPublicKey {
    static final long serialVersionUID = 8712728417091216948L;
    private BigInteger y;
    private ElGamalParameterSpec elSpec;

    JCEElGamalPublicKey(ElGamalPublicKeySpec spec) {
        this.y = spec.getY();
        this.elSpec = new ElGamalParameterSpec(spec.getParams().getP(), spec.getParams().getG());
    }

    JCEElGamalPublicKey(DHPublicKeySpec spec) {
        this.y = spec.getY();
        this.elSpec = new ElGamalParameterSpec(spec.getP(), spec.getG());
    }

    JCEElGamalPublicKey(ElGamalPublicKey key) {
        this.y = key.getY();
        this.elSpec = key.getParameters();
    }

    JCEElGamalPublicKey(DHPublicKey key) {
        this.y = key.getY();
        this.elSpec = new ElGamalParameterSpec(key.getParams().getP(), key.getParams().getG());
    }

    JCEElGamalPublicKey(ElGamalPublicKeyParameters params) {
        this.y = params.getY();
        this.elSpec = new ElGamalParameterSpec(params.getParameters().getP(), params.getParameters().getG());
    }

    JCEElGamalPublicKey(BigInteger y, ElGamalParameterSpec elSpec) {
        this.y = y;
        this.elSpec = elSpec;
    }

    JCEElGamalPublicKey(SubjectPublicKeyInfo info) {
        ElGamalParameter params = ElGamalParameter.getInstance(info.getAlgorithm().getParameters());
        ASN1Integer derY = null;
        try {
            derY = (ASN1Integer)info.parsePublicKey();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid info structure in DSA public key");
        }
        this.y = derY.getValue();
        this.elSpec = new ElGamalParameterSpec(params.getP(), params.getG());
    }

    @Override
    public String getAlgorithm() {
        return "ElGamal";
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        return KeyUtil.getEncodedSubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(this.elSpec.getP(), this.elSpec.getG())), new ASN1Integer(this.y));
    }

    @Override
    public ElGamalParameterSpec getParameters() {
        return this.elSpec;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    @Override
    public BigInteger getY() {
        return this.y;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.y = (BigInteger)in.readObject();
        this.elSpec = new ElGamalParameterSpec((BigInteger)in.readObject(), (BigInteger)in.readObject());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getY());
        out.writeObject(this.elSpec.getP());
        out.writeObject(this.elSpec.getG());
    }
}

