/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.jsse.provider;

import com.bes.enterprise.cipher.gmssl.TlsProtocol;
import com.bes.enterprise.cipher.jsse.BCSSLConnection;
import com.bes.enterprise.cipher.jsse.BCSSLParameters;
import com.bes.enterprise.cipher.jsse.provider.ContextData;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLConnection;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLContextSpi;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLParameters;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLSessionImpl;
import com.bes.enterprise.cipher.jsse.provider.ProvSSLSocketBase;
import com.bes.enterprise.cipher.jsse.provider.ProvTlsClient;
import com.bes.enterprise.cipher.jsse.provider.ProvTlsClientProtocol;
import com.bes.enterprise.cipher.jsse.provider.ProvTlsManager;
import com.bes.enterprise.cipher.jsse.provider.ProvTlsPeer;
import com.bes.enterprise.cipher.jsse.provider.ProvTlsServer;
import com.bes.enterprise.cipher.jsse.provider.ProvTlsServerProtocol;
import com.bes.enterprise.cipher.jsse.provider.SSLParametersUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;
import javax.net.ssl.X509TrustManager;

class ProvSSLSocketDirect
extends ProvSSLSocketBase
implements ProvTlsManager {
    private static Logger LOG = Logger.getLogger(ProvSSLSocketDirect.class.getName());
    protected final AppDataInput appDataIn = new AppDataInput();
    protected final AppDataOutput appDataOut = new AppDataOutput();
    protected final ProvSSLContextSpi context;
    protected final ContextData contextData;
    protected final ProvSSLParameters sslParameters;
    protected boolean enableSessionCreation = true;
    protected boolean useClientMode = true;
    protected TlsProtocol protocol = null;
    protected ProvTlsPeer protocolPeer = null;
    protected BCSSLConnection connection = null;
    protected SSLSession handshakeSession = null;

    ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, boolean enableSessionCreation, boolean useClientMode, ProvSSLParameters sslParameters) {
        this.context = context;
        this.contextData = contextData;
        this.enableSessionCreation = enableSessionCreation;
        this.useClientMode = useClientMode;
        this.sslParameters = sslParameters;
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData) {
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port, InetAddress clientAddress, int clientPort) throws IOException {
        super(address, port, clientAddress, clientPort);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, InetAddress address, int port) throws IOException {
        super(address, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, String host, int port, InetAddress clientAddress, int clientPort) throws IOException, UnknownHostException {
        super(host, port, clientAddress, clientPort);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    protected ProvSSLSocketDirect(ProvSSLContextSpi context, ContextData contextData, String host, int port) throws IOException, UnknownHostException {
        super(host, port);
        this.context = context;
        this.contextData = contextData;
        this.sslParameters = context.getDefaultParameters(!this.useClientMode);
    }

    @Override
    public ProvSSLContextSpi getContext() {
        return this.context;
    }

    @Override
    public ContextData getContextData() {
        return this.contextData;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.protocol == null) {
            this.closeSocket();
        } else {
            this.protocol.close();
        }
    }

    @Override
    public synchronized BCSSLConnection getConnection() {
        try {
            this.handshakeIfNecessary(false);
        }
        catch (IOException e) {
            LOG.log(Level.FINE, "Failed to establish connection", e);
        }
        return this.connection;
    }

    @Override
    public synchronized String[] getEnabledCipherSuites() {
        return this.sslParameters.getCipherSuites();
    }

    @Override
    public synchronized String[] getEnabledProtocols() {
        return this.sslParameters.getProtocols();
    }

    @Override
    public synchronized boolean getEnableSessionCreation() {
        return this.enableSessionCreation;
    }

    @Override
    public synchronized SSLSession getHandshakeSession() {
        return this.handshakeSession;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.appDataIn;
    }

    @Override
    public synchronized boolean getNeedClientAuth() {
        return this.sslParameters.getNeedClientAuth();
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        return this.appDataOut;
    }

    @Override
    public synchronized BCSSLParameters getParameters() {
        return SSLParametersUtil.getParameters(this.sslParameters);
    }

    @Override
    public synchronized SSLSession getSession() {
        BCSSLConnection connection = this.getConnection();
        return connection == null ? ProvSSLSessionImpl.NULL_SESSION.getExportSession() : connection.getSession();
    }

    @Override
    public synchronized SSLParameters getSSLParameters() {
        return SSLParametersUtil.getSSLParameters(this.sslParameters);
    }

    @Override
    public synchronized String[] getSupportedCipherSuites() {
        return this.context.getSupportedCipherSuites();
    }

    @Override
    public synchronized String[] getSupportedProtocols() {
        return this.context.getSupportedProtocols();
    }

    @Override
    public synchronized boolean getUseClientMode() {
        return this.useClientMode;
    }

    @Override
    public synchronized boolean getWantClientAuth() {
        return this.sslParameters.getWantClientAuth();
    }

    @Override
    public synchronized void setEnabledCipherSuites(String[] suites) {
        this.sslParameters.setCipherSuites(suites);
    }

    @Override
    public synchronized void setEnabledProtocols(String[] protocols) {
        this.sslParameters.setProtocols(protocols);
    }

    @Override
    public synchronized void setEnableSessionCreation(boolean flag) {
        this.enableSessionCreation = flag;
    }

    @Override
    public synchronized void setNeedClientAuth(boolean need) {
        this.sslParameters.setNeedClientAuth(need);
    }

    @Override
    public synchronized void setParameters(BCSSLParameters parameters) {
        SSLParametersUtil.setParameters(this.sslParameters, parameters);
    }

    @Override
    public synchronized void setSSLParameters(SSLParameters sslParameters) {
        SSLParametersUtil.setSSLParameters(this.sslParameters, sslParameters);
    }

    @Override
    public synchronized void setUseClientMode(boolean mode) {
        if (this.useClientMode == mode) {
            return;
        }
        if (this.protocol != null) {
            throw new IllegalArgumentException("Mode cannot be changed after the initial handshake has begun");
        }
        this.useClientMode = mode;
        this.context.updateDefaultProtocols(this.sslParameters, !this.useClientMode);
    }

    @Override
    public synchronized void setWantClientAuth(boolean want) {
        this.sslParameters.setWantClientAuth(want);
    }

    @Override
    public synchronized void startHandshake() throws IOException {
        this.startHandshake(true);
    }

    protected void startHandshake(boolean resumable) throws IOException {
        if (this.protocol == null) {
            InputStream input = super.getInputStream();
            OutputStream output = super.getOutputStream();
            if (this.useClientMode) {
                ProvTlsClientProtocol clientProtocol = new ProvTlsClientProtocol(input, output, this.socketCloser);
                clientProtocol.setResumableHandshake(resumable);
                this.protocol = clientProtocol;
                ProvTlsClient client = new ProvTlsClient(this, this.sslParameters.copy());
                this.protocolPeer = client;
                clientProtocol.connect(client);
            } else {
                ProvTlsServerProtocol serverProtocol = new ProvTlsServerProtocol(input, output, this.socketCloser);
                serverProtocol.setResumableHandshake(resumable);
                this.protocol = serverProtocol;
                ProvTlsServer server = new ProvTlsServer(this, this.sslParameters.copy());
                this.protocolPeer = server;
                serverProtocol.accept(server);
            }
        } else if (this.protocol.isHandshaking()) {
            this.protocol.setResumableHandshake(resumable);
            this.protocol.resumeHandshake();
        } else {
            throw new UnsupportedOperationException("Renegotiation not supported");
        }
    }

    @Override
    public String getPeerHost() {
        String peerHost;
        int pos;
        InetAddress peerAddress = this.getInetAddress();
        if (peerAddress != null && (pos = (peerHost = peerAddress.toString()).lastIndexOf(47)) > 0) {
            return peerHost.substring(0, pos);
        }
        return null;
    }

    @Override
    public int getPeerPort() {
        return this.getPort();
    }

    @Override
    public boolean isClientTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkClientTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public boolean isServerTrusted(X509Certificate[] chain, String authType) {
        X509TrustManager tm = this.contextData.getTrustManager();
        if (tm != null) {
            try {
                tm.checkServerTrusted(chain, authType);
                return true;
            }
            catch (CertificateException certificateException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public synchronized void notifyHandshakeComplete(ProvSSLConnection connection) {
        this.connection = connection;
    }

    synchronized void handshakeIfNecessary(boolean resumable) throws IOException {
        if (this.protocol == null || this.protocol.isHandshaking()) {
            this.startHandshake(resumable);
        }
    }

    class AppDataOutput
    extends OutputStream {
        AppDataOutput() {
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                if (ProvSSLSocketDirect.this.protocol != null) {
                    ProvSSLSocketDirect.this.protocol.flush();
                }
            }
        }

        @Override
        public void write(int b) throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            byte[] buf = new byte[]{(byte)b};
            ProvSSLSocketDirect.this.protocol.writeApplicationData(buf, 0, 1);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            if (len > 0) {
                ProvSSLSocketDirect.this.handshakeIfNecessary(true);
                ProvSSLSocketDirect.this.protocol.writeApplicationData(b, off, len);
            }
        }
    }

    class AppDataInput
    extends InputStream {
        AppDataInput() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int available() throws IOException {
            ProvSSLSocketDirect provSSLSocketDirect = ProvSSLSocketDirect.this;
            synchronized (provSSLSocketDirect) {
                return ProvSSLSocketDirect.this.protocol == null ? 0 : ProvSSLSocketDirect.this.protocol.applicationDataAvailable();
            }
        }

        @Override
        public void close() throws IOException {
            ProvSSLSocketDirect.this.close();
        }

        @Override
        public int read() throws IOException {
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            byte[] buf = new byte[1];
            int ret = ProvSSLSocketDirect.this.protocol.readApplicationData(buf, 0, 1);
            return ret < 0 ? -1 : buf[0] & 0xFF;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            if (len < 1) {
                return 0;
            }
            ProvSSLSocketDirect.this.handshakeIfNecessary(true);
            return ProvSSLSocketDirect.this.protocol.readApplicationData(b, off, len);
        }
    }
}

