/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.math.ec;

import com.bes.enterprise.cipher.math.ec.AbstractECMultiplier;
import com.bes.enterprise.cipher.math.ec.ECAlgorithms;
import com.bes.enterprise.cipher.math.ec.ECCurve;
import com.bes.enterprise.cipher.math.ec.ECPoint;
import com.bes.enterprise.cipher.math.ec.ECPointMap;
import com.bes.enterprise.cipher.math.ec.endo.GLVEndomorphism;
import java.math.BigInteger;

public class GLVMultiplier
extends AbstractECMultiplier {
    protected final ECCurve curve;
    protected final GLVEndomorphism glvEndomorphism;

    public GLVMultiplier(ECCurve curve, GLVEndomorphism glvEndomorphism) {
        if (curve == null || curve.getOrder() == null) {
            throw new IllegalArgumentException("Need curve with known group order");
        }
        this.curve = curve;
        this.glvEndomorphism = glvEndomorphism;
    }

    @Override
    protected ECPoint multiplyPositive(ECPoint p, BigInteger k) {
        if (!this.curve.equals(p.getCurve())) {
            throw new IllegalStateException();
        }
        BigInteger n = p.getCurve().getOrder();
        BigInteger[] ab = this.glvEndomorphism.decomposeScalar(k.mod(n));
        BigInteger a = ab[0];
        BigInteger b = ab[1];
        ECPointMap pointMap = this.glvEndomorphism.getPointMap();
        if (this.glvEndomorphism.hasEfficientPointMap()) {
            return ECAlgorithms.implShamirsTrickWNaf(p, a, pointMap, b);
        }
        return ECAlgorithms.implShamirsTrickWNaf(p, a, pointMap.map(p), b);
    }
}

