/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.math.ec.rfc7748;

import com.bes.enterprise.cipher.math.ec.rfc7748.X25519Field;

public abstract class X25519 {
    private static final int C_A = 486662;
    private static final int C_A24 = 121666;
    private static final int[] PsubS_x = new int[]{64258704, 46628941, 18905110, 42949224, 8920788, 10663709, 35115447, 21804323, 8973338, 4366948};
    private static int[] precompBase = null;

    private static int decode32(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    private static void decodeScalar(byte[] k, int kOff, int[] n) {
        for (int i = 0; i < 8; ++i) {
            n[i] = X25519.decode32(k, kOff + i * 4);
        }
        n[0] = n[0] & 0xFFFFFFF8;
        n[7] = n[7] & Integer.MAX_VALUE;
        n[7] = n[7] | 0x40000000;
    }

    private static void pointDouble(int[] x, int[] z) {
        int[] A = X25519Field.create();
        int[] B = X25519Field.create();
        X25519Field.apm(x, z, A, B);
        X25519Field.sqr(A, A);
        X25519Field.sqr(B, B);
        X25519Field.mul(A, B, x);
        X25519Field.sub(A, B, A);
        X25519Field.mul(A, 121666, z);
        X25519Field.add(z, B, z);
        X25519Field.mul(z, A, z);
    }

    public static synchronized void precompute() {
        if (precompBase != null) {
            return;
        }
        int[] xs = precompBase = new int[2520];
        int[] zs = new int[2510];
        int[] x = X25519Field.create();
        x[0] = 9;
        int[] z = X25519Field.create();
        z[0] = 1;
        int[] n = X25519Field.create();
        int[] d = X25519Field.create();
        X25519Field.apm(x, z, n, d);
        int[] c = X25519Field.create();
        X25519Field.copy(d, 0, c, 0);
        int off = 0;
        while (true) {
            X25519Field.copy(n, 0, xs, off);
            if (off == 2510) break;
            X25519.pointDouble(x, z);
            X25519Field.apm(x, z, n, d);
            X25519Field.mul(n, c, n);
            X25519Field.mul(c, d, c);
            X25519Field.copy(d, 0, zs, off);
            off += 10;
        }
        int[] u = X25519Field.create();
        X25519Field.inv(c, u);
        while (true) {
            X25519Field.copy(xs, off, x, 0);
            X25519Field.mul(x, u, x);
            X25519Field.copy(x, 0, precompBase, off);
            if (off == 0) break;
            X25519Field.copy(zs, off -= 10, z, 0);
            X25519Field.mul(u, z, u);
        }
    }

    public static void scalarMult(byte[] k, int kOff, byte[] u, int uOff, byte[] r, int rOff) {
        int[] n = new int[8];
        X25519.decodeScalar(k, kOff, n);
        int[] x1 = X25519Field.create();
        X25519Field.decode(u, uOff, x1);
        int[] x2 = X25519Field.create();
        X25519Field.copy(x1, 0, x2, 0);
        int[] z2 = X25519Field.create();
        z2[0] = 1;
        int[] x3 = X25519Field.create();
        x3[0] = 1;
        int[] z3 = X25519Field.create();
        int[] t1 = X25519Field.create();
        int[] t2 = X25519Field.create();
        int bit = 254;
        int swap = 1;
        do {
            X25519Field.apm(x3, z3, t1, x3);
            X25519Field.apm(x2, z2, z3, x2);
            X25519Field.mul(t1, x2, t1);
            X25519Field.mul(x3, z3, x3);
            X25519Field.sqr(z3, z3);
            X25519Field.sqr(x2, x2);
            X25519Field.sub(z3, x2, t2);
            X25519Field.mul(t2, 121666, z2);
            X25519Field.add(z2, x2, z2);
            X25519Field.mul(z2, t2, z2);
            X25519Field.mul(x2, z3, x2);
            X25519Field.apm(t1, x3, x3, z3);
            X25519Field.sqr(x3, x3);
            X25519Field.sqr(z3, z3);
            X25519Field.mul(z3, x1, z3);
            int word = --bit >>> 5;
            int shift = bit & 0x1F;
            int kt = n[word] >>> shift & 1;
            X25519Field.cswap(swap ^= kt, x2, x3);
            X25519Field.cswap(swap, z2, z3);
            swap = kt;
        } while (bit >= 3);
        for (int i = 0; i < 3; ++i) {
            X25519.pointDouble(x2, z2);
        }
        X25519Field.inv(z2, z2);
        X25519Field.mul(x2, z2, x2);
        X25519Field.normalize(x2);
        X25519Field.encode(x2, r, rOff);
    }

    public static void scalarMultBase(byte[] k, int kOff, byte[] r, int rOff) {
        X25519.precompute();
        int[] n = new int[8];
        X25519.decodeScalar(k, kOff, n);
        int[] x0 = X25519Field.create();
        int[] x1 = X25519Field.create();
        x1[0] = 1;
        int[] z1 = X25519Field.create();
        z1[0] = 1;
        int[] x2 = X25519Field.create();
        X25519Field.copy(PsubS_x, 0, x2, 0);
        int[] z2 = X25519Field.create();
        z2[0] = 1;
        int[] A = x1;
        int[] B = z1;
        int[] C = x0;
        int[] D = A;
        int[] E = B;
        int off = 0;
        int bit = 3;
        int swap = 1;
        do {
            X25519Field.copy(precompBase, off, x0, 0);
            off += 10;
            int word = bit >>> 5;
            int shift = bit & 0x1F;
            int kt = n[word] >>> shift & 1;
            X25519Field.cswap(swap ^= kt, x1, x2);
            X25519Field.cswap(swap, z1, z2);
            swap = kt;
            X25519Field.apm(x1, z1, A, B);
            X25519Field.mul(x0, B, C);
            X25519Field.carry(A);
            X25519Field.apm(A, C, D, E);
            X25519Field.sqr(D, D);
            X25519Field.sqr(E, E);
            X25519Field.mul(z2, D, x1);
            X25519Field.mul(x2, E, z1);
        } while (++bit < 255);
        for (int i = 0; i < 3; ++i) {
            X25519.pointDouble(x1, z1);
        }
        X25519Field.inv(z1, z1);
        X25519Field.mul(x1, z1, x1);
        X25519Field.normalize(x1);
        X25519Field.encode(x1, r, rOff);
    }
}

