/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.math.ec.rfc7748;

import com.bes.enterprise.cipher.math.ec.rfc7748.X448Field;

public abstract class X448 {
    private static final int C_A = 156326;
    private static final int C_A24 = 39082;
    private static final int[] S_x = new int[]{0xFFFFFFE, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFE, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF, 0xFFFFFFF};
    private static final int[] PsubS_x = new int[]{161294112, 185702364, 163248300, 54522310, 189866924, 105098465, 66174309, 139206530, 156517789, 136025714, 231801628, 246922668, 59251455, 69446896, 83964484, 252685170};
    private static int[] precompBase = null;

    private static int decode32(byte[] bs, int off) {
        int n = bs[off] & 0xFF;
        n |= (bs[++off] & 0xFF) << 8;
        n |= (bs[++off] & 0xFF) << 16;
        return n |= bs[++off] << 24;
    }

    private static void decodeScalar(byte[] k, int kOff, int[] n) {
        for (int i = 0; i < 14; ++i) {
            n[i] = X448.decode32(k, kOff + i * 4);
        }
        n[0] = n[0] & 0xFFFFFFFC;
        n[13] = n[13] | Integer.MIN_VALUE;
    }

    private static void pointDouble(int[] x, int[] z) {
        int[] A = X448Field.create();
        int[] B = X448Field.create();
        X448Field.add(x, z, A);
        X448Field.sub(x, z, B);
        X448Field.sqr(A, A);
        X448Field.sqr(B, B);
        X448Field.mul(A, B, x);
        X448Field.sub(A, B, A);
        X448Field.mul(A, 39082, z);
        X448Field.add(z, B, z);
        X448Field.mul(z, A, z);
    }

    public static synchronized void precompute() {
        if (precompBase != null) {
            return;
        }
        int[] xs = precompBase = new int[7136];
        int[] zs = new int[7120];
        int[] x = X448Field.create();
        x[0] = 5;
        int[] z = X448Field.create();
        z[0] = 1;
        int[] n = X448Field.create();
        int[] d = X448Field.create();
        X448Field.add(x, z, n);
        X448Field.sub(x, z, d);
        int[] c = X448Field.create();
        X448Field.copy(d, 0, c, 0);
        int off = 0;
        while (true) {
            X448Field.copy(n, 0, xs, off);
            if (off == 7120) break;
            X448.pointDouble(x, z);
            X448Field.add(x, z, n);
            X448Field.sub(x, z, d);
            X448Field.mul(n, c, n);
            X448Field.mul(c, d, c);
            X448Field.copy(d, 0, zs, off);
            off += 16;
        }
        int[] u = X448Field.create();
        X448Field.inv(c, u);
        while (true) {
            X448Field.copy(xs, off, x, 0);
            X448Field.mul(x, u, x);
            X448Field.copy(x, 0, precompBase, off);
            if (off == 0) break;
            X448Field.copy(zs, off -= 16, z, 0);
            X448Field.mul(u, z, u);
        }
    }

    public static void scalarMult(byte[] k, int kOff, byte[] u, int uOff, byte[] r, int rOff) {
        int[] n = new int[14];
        X448.decodeScalar(k, kOff, n);
        int[] x1 = X448Field.create();
        X448Field.decode(u, uOff, x1);
        int[] x2 = X448Field.create();
        X448Field.copy(x1, 0, x2, 0);
        int[] z2 = X448Field.create();
        z2[0] = 1;
        int[] x3 = X448Field.create();
        x3[0] = 1;
        int[] z3 = X448Field.create();
        int[] t1 = X448Field.create();
        int[] t2 = X448Field.create();
        int bit = 447;
        int swap = 1;
        do {
            X448Field.add(x3, z3, t1);
            X448Field.sub(x3, z3, x3);
            X448Field.add(x2, z2, z3);
            X448Field.sub(x2, z2, x2);
            X448Field.mul(t1, x2, t1);
            X448Field.mul(x3, z3, x3);
            X448Field.sqr(z3, z3);
            X448Field.sqr(x2, x2);
            X448Field.sub(z3, x2, t2);
            X448Field.mul(t2, 39082, z2);
            X448Field.add(z2, x2, z2);
            X448Field.mul(z2, t2, z2);
            X448Field.mul(x2, z3, x2);
            X448Field.sub(t1, x3, z3);
            X448Field.add(t1, x3, x3);
            X448Field.sqr(x3, x3);
            X448Field.sqr(z3, z3);
            X448Field.mul(z3, x1, z3);
            int word = --bit >>> 5;
            int shift = bit & 0x1F;
            int kt = n[word] >>> shift & 1;
            X448Field.cswap(swap ^= kt, x2, x3);
            X448Field.cswap(swap, z2, z3);
            swap = kt;
        } while (bit >= 2);
        for (int i = 0; i < 2; ++i) {
            X448.pointDouble(x2, z2);
        }
        X448Field.inv(z2, z2);
        X448Field.mul(x2, z2, x2);
        X448Field.normalize(x2);
        X448Field.encode(x2, r, rOff);
    }

    public static void scalarMultBase(byte[] k, int kOff, byte[] r, int rOff) {
        X448.precompute();
        int[] n = new int[14];
        X448.decodeScalar(k, kOff, n);
        int[] x0 = X448Field.create();
        int[] x1 = X448Field.create();
        X448Field.copy(S_x, 0, x1, 0);
        int[] z1 = X448Field.create();
        z1[0] = 1;
        int[] x2 = X448Field.create();
        X448Field.copy(PsubS_x, 0, x2, 0);
        int[] z2 = X448Field.create();
        z2[0] = 1;
        int[] A = X448Field.create();
        int[] B = z1;
        int[] C = x0;
        int[] D = x1;
        int[] E = B;
        int off = 0;
        int bit = 2;
        int swap = 1;
        do {
            X448Field.copy(precompBase, off, x0, 0);
            off += 16;
            int word = bit >>> 5;
            int shift = bit & 0x1F;
            int kt = n[word] >>> shift & 1;
            X448Field.cswap(swap ^= kt, x1, x2);
            X448Field.cswap(swap, z1, z2);
            swap = kt;
            X448Field.add(x1, z1, A);
            X448Field.sub(x1, z1, B);
            X448Field.mul(x0, B, C);
            X448Field.carry(A);
            X448Field.add(A, C, D);
            X448Field.sub(A, C, E);
            X448Field.sqr(D, D);
            X448Field.sqr(E, E);
            X448Field.mul(z2, D, x1);
            X448Field.mul(x2, E, z1);
        } while (++bit < 448);
        for (int i = 0; i < 2; ++i) {
            X448.pointDouble(x1, z1);
        }
        X448Field.inv(z1, z1);
        X448Field.mul(x1, z1, x1);
        X448Field.normalize(x1);
        X448Field.encode(x1, r, rOff);
    }
}

