/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pqc.crypto.gmss.util;

import com.bes.enterprise.cipher.crypto.Digest;

public class GMSSRandom {
    private Digest messDigestTree;

    public GMSSRandom(Digest messDigestTree2) {
        this.messDigestTree = messDigestTree2;
    }

    public byte[] nextSeed(byte[] outseed) {
        byte[] rand = new byte[outseed.length];
        this.messDigestTree.update(outseed, 0, outseed.length);
        rand = new byte[this.messDigestTree.getDigestSize()];
        this.messDigestTree.doFinal(rand, 0);
        this.addByteArrays(outseed, rand);
        this.addOne(outseed);
        return rand;
    }

    private void addByteArrays(byte[] a, byte[] b) {
        int overflow = 0;
        for (int i = 0; i < a.length; ++i) {
            int temp = (0xFF & a[i]) + (0xFF & b[i]) + overflow;
            a[i] = (byte)temp;
            overflow = (byte)(temp >> 8);
        }
    }

    private void addOne(byte[] a) {
        int overflow = 1;
        for (int i = 0; i < a.length; ++i) {
            int temp = (0xFF & a[i]) + overflow;
            a[i] = (byte)temp;
            overflow = (byte)(temp >> 8);
        }
    }
}

