/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.cipher.pqc.crypto.sphincs;

import com.bes.enterprise.cipher.util.Pack;

class Permute {
    private static final int CHACHA_ROUNDS = 12;

    Permute() {
    }

    protected static int rotl(int x, int y) {
        return x << y | x >>> -y;
    }

    public static void permute(int rounds, int[] x) {
        if (x.length != 16) {
            throw new IllegalArgumentException();
        }
        if (rounds % 2 != 0) {
            throw new IllegalArgumentException("Number of rounds must be even");
        }
        int x00 = x[0];
        int x01 = x[1];
        int x02 = x[2];
        int x03 = x[3];
        int x04 = x[4];
        int x05 = x[5];
        int x06 = x[6];
        int x07 = x[7];
        int x08 = x[8];
        int x09 = x[9];
        int x10 = x[10];
        int x11 = x[11];
        int x12 = x[12];
        int x13 = x[13];
        int x14 = x[14];
        int x15 = x[15];
        for (int i = rounds; i > 0; i -= 2) {
            x12 = Permute.rotl(x12 ^ (x00 += x04), 16);
            x04 = Permute.rotl(x04 ^ (x08 += x12), 12);
            x12 = Permute.rotl(x12 ^ (x00 += x04), 8);
            x04 = Permute.rotl(x04 ^ (x08 += x12), 7);
            x13 = Permute.rotl(x13 ^ (x01 += x05), 16);
            x05 = Permute.rotl(x05 ^ (x09 += x13), 12);
            x13 = Permute.rotl(x13 ^ (x01 += x05), 8);
            x05 = Permute.rotl(x05 ^ (x09 += x13), 7);
            x14 = Permute.rotl(x14 ^ (x02 += x06), 16);
            x06 = Permute.rotl(x06 ^ (x10 += x14), 12);
            x14 = Permute.rotl(x14 ^ (x02 += x06), 8);
            x06 = Permute.rotl(x06 ^ (x10 += x14), 7);
            x15 = Permute.rotl(x15 ^ (x03 += x07), 16);
            x07 = Permute.rotl(x07 ^ (x11 += x15), 12);
            x15 = Permute.rotl(x15 ^ (x03 += x07), 8);
            x07 = Permute.rotl(x07 ^ (x11 += x15), 7);
            x15 = Permute.rotl(x15 ^ (x00 += x05), 16);
            x05 = Permute.rotl(x05 ^ (x10 += x15), 12);
            x15 = Permute.rotl(x15 ^ (x00 += x05), 8);
            x05 = Permute.rotl(x05 ^ (x10 += x15), 7);
            x12 = Permute.rotl(x12 ^ (x01 += x06), 16);
            x06 = Permute.rotl(x06 ^ (x11 += x12), 12);
            x12 = Permute.rotl(x12 ^ (x01 += x06), 8);
            x06 = Permute.rotl(x06 ^ (x11 += x12), 7);
            x13 = Permute.rotl(x13 ^ (x02 += x07), 16);
            x07 = Permute.rotl(x07 ^ (x08 += x13), 12);
            x13 = Permute.rotl(x13 ^ (x02 += x07), 8);
            x07 = Permute.rotl(x07 ^ (x08 += x13), 7);
            x14 = Permute.rotl(x14 ^ (x03 += x04), 16);
            x04 = Permute.rotl(x04 ^ (x09 += x14), 12);
            x14 = Permute.rotl(x14 ^ (x03 += x04), 8);
            x04 = Permute.rotl(x04 ^ (x09 += x14), 7);
        }
        x[0] = x00;
        x[1] = x01;
        x[2] = x02;
        x[3] = x03;
        x[4] = x04;
        x[5] = x05;
        x[6] = x06;
        x[7] = x07;
        x[8] = x08;
        x[9] = x09;
        x[10] = x10;
        x[11] = x11;
        x[12] = x12;
        x[13] = x13;
        x[14] = x14;
        x[15] = x15;
    }

    void chacha_permute(byte[] out, byte[] in) {
        int i;
        int[] x = new int[16];
        for (i = 0; i < 16; ++i) {
            x[i] = Pack.littleEndianToInt(in, 4 * i);
        }
        Permute.permute(12, x);
        for (i = 0; i < 16; ++i) {
            Pack.intToLittleEndian(x[i], out, 4 * i);
        }
    }
}

