/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.web.jasper.compiler;

import com.bes.enterprise.web.jasper.JasperException;
import com.bes.enterprise.web.jasper.compiler.ErrorDispatcher;
import com.bes.enterprise.web.jasper.compiler.Node;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import javax.servlet.jsp.tagext.TagVariableInfo;
import javax.servlet.jsp.tagext.VariableInfo;

class ScriptingVariabler {
    private static final Integer MAX_SCOPE = Integer.MAX_VALUE;

    ScriptingVariabler() {
    }

    public static void set(Node.Nodes page, ErrorDispatcher err) throws JasperException {
        page.visit(new CustomTagCounter());
        page.visit(new ScriptingVariableVisitor(err));
    }

    private static class ScriptingVariableVisitor
    extends Node.Visitor {
        private final ErrorDispatcher err;
        private final Map<String, Integer> scriptVars;
        private Stack<String> scopeStack = new Stack();
        public static char CLB = (char)123;
        public static char CRB = (char)125;
        public static String SLB = "{";
        public static String SRB = "}";
        public static char DQ = (char)34;
        public static char SQ = (char)39;
        public static boolean varScopeCheck = Boolean.parseBoolean(System.getProperty("com.bes.web.jsp.compile.checkVarScope", "true"));

        public ScriptingVariableVisitor(ErrorDispatcher err) {
            this.err = err;
            this.scriptVars = new HashMap<String, Integer>();
        }

        @Override
        public void visit(Node.Scriptlet n) {
            int n2;
            if (!varScopeCheck) {
                return;
            }
            JspScriptReader reader = new JspScriptReader(n.getText().toCharArray());
            int n3 = -1;
            while ((n2 = reader.nextChar()) != -1) {
                if (n2 == DQ) {
                    reader.skipUntil(DQ);
                    continue;
                }
                if (n2 == SQ) {
                    reader.skipUntil(SQ);
                    continue;
                }
                if (n2 == 47 && reader.peekChar() == 47) {
                    reader.skipUntil("\n");
                    continue;
                }
                if (n2 == 47 && reader.peekChar() == 42) {
                    reader.skipUntil("*/");
                    continue;
                }
                if (n2 == CLB) {
                    this.scopeStack.push(SLB);
                    continue;
                }
                if (n2 != CRB) continue;
                while (!this.scopeStack.isEmpty() && !this.scopeStack.peek().equals(SLB)) {
                    this.scopeStack.pop();
                }
                if (this.scopeStack.isEmpty() || !this.scopeStack.peek().equals(SLB)) continue;
                this.scopeStack.pop();
            }
        }

        @Override
        public void visit(Node.CustomTag n) throws JasperException {
            this.setScriptingVars(n, 1);
            this.setScriptingVars(n, 0);
            this.visitBody(n);
            this.setScriptingVars(n, 2);
        }

        /*
         * WARNING - void declaration
         */
        private void setScriptingVars(Node.CustomTag n, int scope) throws JasperException {
            Integer currentRange;
            int i;
            TagVariableInfo[] tagVarInfos = n.getTagVariableInfos();
            VariableInfo[] varInfos = n.getVariableInfos();
            if (tagVarInfos.length == 0 && varInfos.length == 0) {
                return;
            }
            ArrayList<Object> vec = new ArrayList<Object>();
            Integer ownRange = null;
            Node.CustomTag parent = n.getCustomTagParent();
            ownRange = scope == 1 || scope == 2 ? (parent == null ? MAX_SCOPE : parent.getNumCount()) : n.getNumCount();
            if (varInfos.length > 0) {
                for (i = 0; i < varInfos.length; ++i) {
                    String string;
                    if (varInfos[i].getScope() != scope || !varInfos[i].getDeclare() || (currentRange = this.scriptVars.get(string = varInfos[i].getVarName())) != null && ownRange.compareTo(currentRange) <= 0 && (!varScopeCheck || this.scopeStack.contains(string))) continue;
                    this.scriptVars.put(string, ownRange);
                    vec.add(varInfos[i]);
                }
            } else {
                for (i = 0; i < tagVarInfos.length; ++i) {
                    void var9_11;
                    String string;
                    if (tagVarInfos[i].getScope() != scope || !tagVarInfos[i].getDeclare()) continue;
                    String string2 = tagVarInfos[i].getNameGiven();
                    if (string2 == null && (string = n.getTagData().getAttributeString(tagVarInfos[i].getNameFromAttribute())) == null) {
                        this.err.jspError((Node)n, "jsp.error.scripting.variable.missing_name", tagVarInfos[i].getNameFromAttribute());
                    }
                    if ((currentRange = this.scriptVars.get(var9_11)) != null && ownRange.compareTo(currentRange) <= 0 && (!varScopeCheck || this.scopeStack.contains(var9_11))) continue;
                    this.scriptVars.put((String)var9_11, ownRange);
                    vec.add(tagVarInfos[i]);
                }
            }
            if (varScopeCheck) {
                for (Object e : vec) {
                    if (e instanceof VariableInfo) {
                        this.scopeStack.push(((VariableInfo)e).getVarName());
                        continue;
                    }
                    if (!(e instanceof TagVariableInfo)) continue;
                    String varName2 = ((TagVariableInfo)e).getNameGiven();
                    if (varName2 == null) {
                        varName2 = n.getTagData().getAttributeString(((TagVariableInfo)e).getNameFromAttribute());
                    }
                    this.scopeStack.push(varName2);
                }
            }
            n.setScriptingVars(vec, scope);
        }

        final class Mark {
            int cursor;
            int line;
            int col;
            char[] stream = null;

            public Mark(char[] inStream) {
                this.stream = inStream;
                this.cursor = 0;
                this.line = 1;
                this.col = 1;
            }

            public Mark(Mark other) {
                this.cursor = other.cursor;
                this.line = other.line;
                this.col = other.col;
                this.stream = other.stream;
            }

            public String toString() {
                return "Mark [cursor=" + this.cursor + ", line=" + this.line + ", col=" + this.col + ", stream=" + Arrays.toString(this.stream) + "]";
            }
        }

        class JspScriptReader {
            private Mark current;

            public JspScriptReader(char[] inStream) {
                this.current = new Mark(inStream);
            }

            public Mark skipUntil(char limit) {
                boolean escape = false;
                int ch = this.nextChar();
                while (ch != -1) {
                    block6: {
                        block5: {
                            if (ch != 92) break block5;
                            ch = this.nextChar();
                            if (ch == 92) break block6;
                            escape = true;
                        }
                        if (ch == limit && !escape) {
                            return new Mark(this.current);
                        }
                        escape = false;
                    }
                    ch = this.nextChar();
                }
                return null;
            }

            public Mark skipUntil(String limit) {
                int limLen = limit.length();
                int ch = this.nextChar();
                while (ch != -1) {
                    block4: {
                        if (ch == limit.charAt(0)) {
                            Mark restart = this.mark();
                            for (int i = 1; i < limLen; ++i) {
                                if (this.peekChar() != limit.charAt(i)) {
                                    this.reset(restart);
                                    break block4;
                                }
                                this.nextChar();
                            }
                            return this.mark();
                        }
                    }
                    ch = this.nextChar();
                }
                return null;
            }

            public int nextChar() {
                if (!this.hasMoreInput()) {
                    return -1;
                }
                char ch = this.current.stream[this.current.cursor];
                ++this.current.cursor;
                if (ch == '\n') {
                    ++this.current.line;
                    this.current.col = 0;
                } else {
                    ++this.current.col;
                }
                return ch;
            }

            public int peekChar() {
                if (!this.hasMoreInput()) {
                    return -1;
                }
                return this.current.stream[this.current.cursor];
            }

            public void reset(Mark mark) {
                this.current = new Mark(mark);
            }

            public Mark mark() {
                return new Mark(this.current);
            }

            public boolean hasMoreInput() {
                return this.current.stream != null && this.current.cursor < this.current.stream.length;
            }
        }
    }

    private static class CustomTagCounter
    extends Node.Visitor {
        private int count;
        private Node.CustomTag parent;

        private CustomTagCounter() {
        }

        @Override
        public void visit(Node.CustomTag n) throws JasperException {
            n.setCustomTagParent(this.parent);
            Node.CustomTag tmpParent = this.parent;
            this.parent = n;
            this.visitBody(n);
            this.parent = tmpParent;
            n.setNumCount(this.count++);
        }
    }
}

