/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.jdbc.spring.boot.autoconfigure;

import com.bes.enterprise.config.provider.CipherAlgorithmProviderFactory;
import com.bes.enterprise.gjc.spi.BasicDataSource;
import com.bes.enterprise.web.util.IntrospectionUtils;
import com.bes.enterprise.web.util.descriptor.besweb.Property;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.jdbc.DataSourceProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.datasource.bes")
public class BesDataSourceWrapper
extends BasicDataSource
implements InitializingBean {
    @Autowired
    private DataSourceProperties basicProperties;
    private String isolationLevel;
    private List<Property> properties = new ArrayList<Property>();
    private static final Integer timeBetweenEvictionRunsMillisUpper = Integer.getInteger("com.bes.enterprise.jdbc.timeBetweenEvictionRunsMillis.UpperLimit", 60000);
    private Long timeBetweenEvictionRunsMillisMark;
    private Integer numTestsPerEvictionRunMark;
    private CipherAlgorithmProviderFactory algorithmProviderFactory = CipherAlgorithmProviderFactory.getInstance();

    public void afterPropertiesSet() throws Exception {
        if (super.getUsername() == null) {
            super.setUsername(this.basicProperties.determineUsername());
        }
        if (super.getPassword() == null) {
            this.setPassword(this.basicProperties.determinePassword());
        }
        if (super.getUrl() == null) {
            super.setUrl(this.basicProperties.determineUrl());
        }
        if (super.getDriverClassName() == null) {
            super.setDriverClassName(this.basicProperties.getDriverClassName());
        }
        if (super.getName() == null) {
            super.setName("unspecified");
        }
        if (super.getJmxName() == null) {
            super.setJmxName("com.bes.enterprise.management:type=datasources,name=" + this.getName());
        }
        if (this.timeBetweenEvictionRunsMillisMark == null) {
            int dataToCalculate;
            int idleTimeout = this.getIdleTimeout();
            int connectionLeakTimeoutInSeconds = this.getConnectionLeakTimeoutInSeconds();
            int n = dataToCalculate = idleTimeout > 0 && connectionLeakTimeoutInSeconds > 0 ? Math.min(idleTimeout, connectionLeakTimeoutInSeconds) : Math.max(idleTimeout, connectionLeakTimeoutInSeconds);
            if (dataToCalculate > 0) {
                int finalValue = Math.min(dataToCalculate * 1000 / 3, timeBetweenEvictionRunsMillisUpper);
                super.setTimeBetweenEvictionRunsMillis((long)finalValue);
            } else {
                super.setTimeBetweenEvictionRunsMillis((long)timeBetweenEvictionRunsMillisUpper.intValue());
            }
        }
        if (this.numTestsPerEvictionRunMark != null) {
            if (this.numTestsPerEvictionRunMark >= 0) {
                super.setNumTestsPerEvictionRun(this.numTestsPerEvictionRunMark.intValue());
            } else {
                int finalValue = (int)Math.ceil(this.getMaxPoolSize() / Math.abs(this.numTestsPerEvictionRunMark));
                super.setNumTestsPerEvictionRun(finalValue);
            }
        } else {
            super.setNumTestsPerEvictionRun(this.getMaxPoolSize());
        }
        for (Property property : this.properties) {
            IntrospectionUtils.setProperty((Object)((Object)this), (String)property.getName(), (String)property.getValue());
        }
    }

    public void setPassword(String password) {
        try {
            if (this.algorithmProviderFactory.isCipherText(password)) {
                password = this.algorithmProviderFactory.decrypt(password);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        super.setPassword(password);
    }

    public void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillisMark = timeBetweenEvictionRunsMillis;
        super.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
    }

    public void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRunMark = numTestsPerEvictionRun;
        super.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
    }

    public String getIsolationLevel() {
        return this.isolationLevel;
    }

    public void setIsolationLevel(String isolationLevel) {
        if (StringUtils.hasLength((String)isolationLevel)) {
            int level = -1;
            if ("NONE".equalsIgnoreCase(isolationLevel)) {
                level = 0;
            } else if ("READ_COMMITTED".equalsIgnoreCase(isolationLevel)) {
                level = 2;
            } else if ("READ_UNCOMMITTED".equalsIgnoreCase(isolationLevel)) {
                level = 1;
            } else if ("REPEATABLE_READ".equalsIgnoreCase(isolationLevel)) {
                level = 4;
            } else if ("SERIALIZABLE".equalsIgnoreCase(isolationLevel)) {
                level = 8;
            } else {
                try {
                    level = Integer.parseInt(isolationLevel);
                }
                catch (NumberFormatException e) {
                    System.err.println("Could not parse isolationLevel: " + isolationLevel);
                    System.err.println("WARNING: isolationLevel not set");
                    System.err.println("using default value of database driver");
                    level = -1;
                }
            }
            super.setDefaultTransactionIsolation(level);
        }
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }
}

