/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.pool.impl;

import com.bes.enterprise.gjc.pool.impl.LinkedBlockingDeque;
import com.bes.enterprise.gjc.pool.impl.QueueAdapter;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;

public class BESQueueLIFO<E>
implements QueueAdapter<E> {
    private LinkedBlockingDeque<E> queue;

    public BESQueueLIFO() {
        this.queue = new LinkedBlockingDeque();
    }

    public BESQueueLIFO(int intSize) {
        this.queue = new LinkedBlockingDeque(intSize);
    }

    public BESQueueLIFO(int intSize, boolean fairness) {
        this.queue = new LinkedBlockingDeque(intSize, fairness);
    }

    public BESQueueLIFO(boolean fairness) {
        this.queue = new LinkedBlockingDeque(fairness);
    }

    @Override
    public E poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.pollFirst(timeout, unit);
    }

    @Override
    public E poll() {
        return this.queue.pollFirst();
    }

    @Override
    public void add(E e) {
        this.queue.addFirst(e);
    }

    @Override
    public boolean offer(E e) {
        return this.queue.offerFirst(e);
    }

    @Override
    public boolean offer(E e, long timeout, TimeUnit unit) throws InterruptedException {
        return this.queue.offerFirst(e, timeout, unit);
    }

    @Override
    public boolean remove(Object o) {
        return this.queue.remove(o);
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public Iterator<E> iterator() {
        return this.queue.descendingIterator();
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public boolean hasTakeWaiters() {
        return this.queue.hasTakeWaiters();
    }

    @Override
    public int getTakeQueueLength() {
        return this.queue.getTakeQueueLength();
    }

    @Override
    public void interuptTakeWaiters() {
        this.queue.interuptTakeWaiters();
    }

    @Override
    public E take() throws InterruptedException {
        return this.queue.takeFirst();
    }
}

