/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.pool.impl;

import com.bes.enterprise.gjc.pool.ClockSource;
import com.bes.enterprise.gjc.pool.PooledObject;
import com.bes.enterprise.gjc.pool.PooledObjectState;
import com.bes.enterprise.gjc.pool.impl.EvictionConfig;
import com.bes.enterprise.gjc.pool.impl.EvictionPolicy;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultEvictionPolicy<T>
implements EvictionPolicy<T> {
    private static final ClockSource clockSource = ClockSource.INSTANCE;
    private static final Logger logger = Logger.getLogger(DefaultEvictionPolicy.class.getName());

    @Override
    public boolean evict(EvictionConfig config, PooledObject<T> underTest, int idleCount) {
        long lifetime;
        if (underTest.getState() == PooledObjectState.STALE) {
            return true;
        }
        if (config.getIdleSoftEvictTime() < underTest.getIdleTimeMillis() && config.getMinIdle() < idleCount || config.getIdleEvictTime() < underTest.getIdleTimeMillis()) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINE, "Connection idle timeout : " + underTest.getObject().toString());
            }
            return true;
        }
        return config.getMaxLifetimeMillis() > 0L && (lifetime = clockSource.elapsedMillis(underTest.getCreateTime())) > config.getMaxLifetimeMillis();
    }
}

