/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.appserver.common.resource.ExternalResoureManager;
import com.bes.enterprise.appserver.common.resource.ResourceKey;
import com.bes.enterprise.appserver.common.resource.Sharable;
import com.bes.enterprise.appserver.common.resource.SharableKey;
import com.bes.enterprise.appserver.common.resource.SharableResource;
import com.bes.enterprise.appserver.common.resource.SharableResourceContext;
import com.bes.enterprise.appserver.common.resource.SharableResourceManager;
import com.bes.enterprise.gjc.pool.PooledObject;
import com.bes.enterprise.gjc.pool.impl.AbandonedConfig;
import com.bes.enterprise.gjc.pool.impl.DefaultThreadFactory;
import com.bes.enterprise.gjc.pool.impl.GenericObjectPool;
import com.bes.enterprise.gjc.pool.impl.GenericObjectPoolConfig;
import com.bes.enterprise.gjc.spi.BasicDataSourceMXBean;
import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.DelegatingConnection;
import com.bes.enterprise.gjc.spi.DriverConnectionFactory;
import com.bes.enterprise.gjc.spi.PoolableConnection;
import com.bes.enterprise.gjc.spi.PoolableConnectionFactory;
import com.bes.enterprise.gjc.spi.PoolingDataSource;
import com.bes.enterprise.gjc.spi.QueryReport;
import com.bes.enterprise.gjc.spi.SwallowedExceptionLogger;
import com.bes.enterprise.gjc.spi.Utils;
import com.bes.enterprise.gjc.spi.cache.impl.BesJdbcCache;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.ManagementFactory;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.JMException;
import javax.management.MBeanRegistration;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.sql.DataSource;

public class BasicDataSource
implements DataSource,
BasicDataSourceMXBean,
MBeanRegistration,
AutoCloseable {
    private static final Log log = LogFactory.getLog(BasicDataSource.class);
    private BesJdbcCache resultSetCache;
    protected QueryReport queryReport;
    protected String name;
    private final long SHUTDOWN_TIMEOUT_IN_MILLIS = 1000L;
    private volatile Boolean defaultAutoCommit = null;
    private transient Boolean defaultReadOnly = null;
    private volatile int defaultTransactionIsolation = -1;
    private Integer statementTimeoutInSeconds = -1;
    private Integer fetchSize = 0;
    private volatile String defaultCatalog = null;
    private boolean cacheState = true;
    private Driver driver = null;
    private String driverClassName = null;
    private ClassLoader driverClassLoader = null;
    private boolean lifo = true;
    private int maxPoolSize = 32;
    private int maxIdle = -1;
    private int minIdle = 0;
    private int initialPoolSize = 8;
    private long maxWaitTimeInMillis = 60000L;
    private boolean poolPreparedStatements = false;
    private boolean poolStatements = false;
    private int statementCacheSize = 10;
    private boolean testOnCreate = false;
    private boolean testOnBorrow = true;
    private boolean testOnReturn = false;
    private long timeBetweenEvictionRunsMillis = -1L;
    private int numTestsPerEvictionRun = 3;
    private long maxEvictableIdleTimeout = 1800000L;
    private int idleTimeout = 300;
    private String evictionPolicyClassName = "com.bes.enterprise.gjc.pool.impl.DefaultEvictionPolicy";
    private boolean testWhileIdle = false;
    private volatile String password = null;
    private String url = null;
    private String username = null;
    private volatile String validationQuery = null;
    private volatile int validationQueryTimeout = 0;
    private volatile int validateAtmostOncePeriodInSeconds = 120;
    private volatile boolean matchConnections = false;
    private volatile boolean createOnInitialize = false;
    private volatile List<String> connectionInitSqls;
    private boolean accessToUnderlyingConnectionAllowed = false;
    private long maxConnectionAge = 0L;
    private boolean logExpiredConnections = true;
    private String jmxName = null;
    private boolean enableAutoCommitOnReturn = false;
    private boolean rollbackOnReturn = false;
    private boolean sqlTrace = false;
    private int maxQueries = 1000;
    private boolean logSlow = false;
    private boolean logFailed = false;
    private long slowSqlThreshold = 1000L;
    private volatile Set<String> disconnectionSqlCodes;
    private boolean failAllConnection;
    private boolean fastFailValidation;
    private boolean usingTrace;
    private boolean wrapStatement = true;
    private int standbySize;
    private int standbyLevel = 2;
    private boolean fairness;
    private boolean enableSharingResources = false;
    private volatile GenericObjectPool<PoolableConnection> connectionPool = null;
    protected Properties connectionProperties = new Properties();
    public volatile PoolingDataSource dataSource = null;
    protected volatile PrintWriter logWriter = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, StandardCharsets.UTF_8));
    private AbandonedConfig abandonedConfig;
    private boolean enableLeakageRecovery = false;
    private int connectionLeakTimeoutInSeconds = 0;
    private boolean logAbandoned = true;
    private boolean closed;
    private Executor netTimeoutExecutor;
    private ObjectName registeredJmxName = null;

    @Override
    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    @Override
    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    @Override
    public int getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(int defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public Integer getStatementTimeoutInSeconds() {
        return this.statementTimeoutInSeconds;
    }

    public void setStatementTimeoutInSeconds(Integer statementTimeoutInSeconds) {
        this.statementTimeoutInSeconds = statementTimeoutInSeconds;
    }

    public Integer getFetchSize() {
        return this.fetchSize;
    }

    public void setFetchSize(Integer fetchSize) {
        this.fetchSize = fetchSize;
    }

    @Override
    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog != null && defaultCatalog.trim().length() > 0 ? defaultCatalog : null;
    }

    @Override
    public boolean getCacheState() {
        return this.cacheState;
    }

    public void setCacheState(boolean cacheState) {
        this.cacheState = cacheState;
    }

    public synchronized Driver getDriver() {
        return this.driver;
    }

    public synchronized void setDriver(Driver driver) {
        this.driver = driver;
    }

    @Override
    public synchronized String getDriverClassName() {
        return this.driverClassName;
    }

    public synchronized void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName != null && driverClassName.trim().length() > 0 ? driverClassName : null;
    }

    public synchronized ClassLoader getDriverClassLoader() {
        return this.driverClassLoader;
    }

    public synchronized void setDriverClassLoader(ClassLoader driverClassLoader) {
        this.driverClassLoader = driverClassLoader;
    }

    @Override
    public synchronized boolean getLifo() {
        return this.lifo;
    }

    public synchronized void setLifo(boolean lifo) {
        this.lifo = lifo;
        if (this.connectionPool != null) {
            this.connectionPool.setLifo(lifo);
        }
    }

    @Override
    public synchronized int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public synchronized void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxTotal(maxPoolSize);
        }
    }

    @Override
    public synchronized int getMaxIdle() {
        return this.maxIdle;
    }

    public synchronized void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxIdle(maxIdle);
        }
    }

    @Override
    public synchronized int getMinIdle() {
        return this.minIdle;
    }

    public synchronized void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setMinIdle(minIdle);
        }
    }

    @Override
    public synchronized int getInitialPoolSize() {
        return this.initialPoolSize;
    }

    public synchronized void setInitialPoolSize(int initialPoolSize) {
        this.initialPoolSize = initialPoolSize;
    }

    @Override
    public synchronized long getMaxWaitTimeInMillis() {
        return this.maxWaitTimeInMillis;
    }

    public synchronized void setMaxWaitTimeInMillis(long maxWaitTimeInMillis) {
        this.maxWaitTimeInMillis = maxWaitTimeInMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxWaitMillis(maxWaitTimeInMillis);
        }
    }

    @Override
    public synchronized boolean isPoolPreparedStatements() {
        return this.poolPreparedStatements;
    }

    public synchronized void setPoolPreparedStatements(boolean poolingStatements) {
        this.poolPreparedStatements = poolingStatements;
    }

    @Override
    public synchronized boolean isPoolStatements() {
        return this.poolStatements;
    }

    public synchronized void setPoolStatements(boolean poolStatements) {
        this.poolStatements = poolStatements;
    }

    @Override
    public synchronized int getStatementCacheSize() {
        return this.statementCacheSize;
    }

    public synchronized void setStatementCacheSize(int maxOpenStatements) {
        this.statementCacheSize = maxOpenStatements;
    }

    @Override
    public synchronized boolean getTestOnCreate() {
        return this.testOnCreate;
    }

    public synchronized void setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate = testOnCreate;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnCreate(testOnCreate);
        }
    }

    @Override
    public synchronized boolean getTestOnBorrow() {
        return this.testOnBorrow;
    }

    public synchronized void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnBorrow(testOnBorrow);
        }
    }

    public synchronized boolean getTestOnReturn() {
        return this.testOnReturn;
    }

    public synchronized void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
        if (this.connectionPool != null) {
            this.connectionPool.setTestOnReturn(testOnReturn);
        }
    }

    @Override
    public synchronized long getTimeBetweenEvictionRunsMillis() {
        return this.timeBetweenEvictionRunsMillis;
    }

    public synchronized void setTimeBetweenEvictionRunsMillis(long timeBetweenEvictionRunsMillis) {
        this.timeBetweenEvictionRunsMillis = timeBetweenEvictionRunsMillis;
        if (this.connectionPool != null) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(timeBetweenEvictionRunsMillis);
        }
    }

    @Override
    public synchronized int getNumTestsPerEvictionRun() {
        return this.numTestsPerEvictionRun;
    }

    public synchronized void setNumTestsPerEvictionRun(int numTestsPerEvictionRun) {
        this.numTestsPerEvictionRun = numTestsPerEvictionRun;
        if (this.connectionPool != null) {
            this.connectionPool.setNumTestsPerEvictionRun(numTestsPerEvictionRun);
        }
    }

    @Override
    public synchronized long getMaxEvictableIdleTimeout() {
        return this.maxEvictableIdleTimeout;
    }

    public synchronized void setMaxEvictableIdleTimeout(long maxEvictableIdleTimeout) {
        this.maxEvictableIdleTimeout = maxEvictableIdleTimeout;
        if (this.connectionPool != null) {
            this.connectionPool.setMaxEvictableIdleTimeMillis(maxEvictableIdleTimeout);
        }
    }

    public synchronized void setIdleTimeout(int idleTimeout) {
        this.idleTimeout = idleTimeout;
        if (this.connectionPool != null) {
            this.connectionPool.setMinEvictableIdleTimeMillis(idleTimeout);
        }
    }

    @Override
    public synchronized int getIdleTimeout() {
        return this.idleTimeout;
    }

    public synchronized String getEvictionPolicyClassName() {
        return this.evictionPolicyClassName;
    }

    public synchronized void setEvictionPolicyClassName(String evictionPolicyClassName) {
        if (this.connectionPool != null) {
            this.connectionPool.setEvictionPolicyClassName(evictionPolicyClassName);
        }
        this.evictionPolicyClassName = evictionPolicyClassName;
    }

    @Override
    public synchronized boolean getTestWhileIdle() {
        return this.testWhileIdle;
    }

    public synchronized void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
        if (this.connectionPool != null) {
            this.connectionPool.setTestWhileIdle(testWhileIdle);
        }
    }

    @Override
    public int getNumActive() {
        GenericObjectPool<PoolableConnection> pool = this.connectionPool;
        if (pool != null) {
            return pool.getNumActive();
        }
        return 0;
    }

    @Override
    public int getNumIdle() {
        GenericObjectPool<PoolableConnection> pool = this.connectionPool;
        if (pool != null) {
            return pool.getNumIdle();
        }
        return 0;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    @Override
    public synchronized String getUrl() {
        return this.url;
    }

    public synchronized void setUrl(String url) {
        this.url = url;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    @Override
    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery != null && validationQuery.trim().length() > 0 ? validationQuery : null;
    }

    @Override
    public int getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(int timeout) {
        this.validationQueryTimeout = timeout;
    }

    public int getValidateAtmostOncePeriodInSeconds() {
        return this.validateAtmostOncePeriodInSeconds;
    }

    public void setValidateAtmostOncePeriodInSeconds(int validateAtmostOncePeriodInSeconds) {
        this.validateAtmostOncePeriodInSeconds = validateAtmostOncePeriodInSeconds;
    }

    public void setMatchConnections(boolean matchConnections) {
        this.matchConnections = matchConnections;
        if (this.connectionPool != null) {
            this.connectionPool.setMatchConnections(matchConnections);
        }
    }

    public boolean isMatchConnections() {
        return this.matchConnections;
    }

    public void setCreateOnInitialize(boolean createOnInitialize) {
        this.createOnInitialize = createOnInitialize;
    }

    public Boolean getCreateOnInitialize() {
        return this.createOnInitialize;
    }

    public List<String> getConnectionInitSqls() {
        List<String> result = this.connectionInitSqls;
        if (result == null) {
            return Collections.emptyList();
        }
        return result;
    }

    @Override
    public String[] getConnectionInitSqlsAsArray() {
        List<String> result = this.getConnectionInitSqls();
        return result.toArray(new String[result.size()]);
    }

    public void setConnectionInitSqls(Collection<String> connectionInitSqls) {
        if (connectionInitSqls != null && connectionInitSqls.size() > 0) {
            ArrayList<String> newVal = null;
            for (String s : connectionInitSqls) {
                if (s == null || s.trim().length() <= 0) continue;
                if (newVal == null) {
                    newVal = new ArrayList<String>();
                }
                newVal.add(s);
            }
            this.connectionInitSqls = newVal;
        } else {
            this.connectionInitSqls = null;
        }
    }

    @Override
    public synchronized boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public synchronized void setAccessToUnderlyingConnectionAllowed(boolean allow) {
        this.accessToUnderlyingConnectionAllowed = allow;
    }

    @Override
    public long getMaxConnectionAge() {
        return this.maxConnectionAge;
    }

    @Override
    public boolean getLogExpiredConnections() {
        return this.logExpiredConnections;
    }

    public void setMaxConnectionAge(long maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge;
    }

    public void setLogExpiredConnections(boolean logExpiredConnections) {
        this.logExpiredConnections = logExpiredConnections;
    }

    public String getJmxName() {
        return this.jmxName;
    }

    public void setJmxName(String jmxName) {
        this.jmxName = jmxName;
    }

    public boolean getEnableAutoCommitOnReturn() {
        return this.enableAutoCommitOnReturn;
    }

    public void setEnableAutoCommitOnReturn(boolean enableAutoCommitOnReturn) {
        this.enableAutoCommitOnReturn = enableAutoCommitOnReturn;
    }

    public boolean getRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    public boolean getSqlTrace() {
        return this.sqlTrace;
    }

    public void setSqlTrace(boolean sqlTrace) {
        this.sqlTrace = sqlTrace;
    }

    public int getMaxQueries() {
        return this.maxQueries;
    }

    public void setMaxQueries(int maxQueries) {
        this.maxQueries = maxQueries;
    }

    public boolean getLogSlow() {
        return this.logSlow;
    }

    public void setLogSlow(boolean logSlow) {
        this.logSlow = logSlow;
    }

    public boolean getlogFailed() {
        return this.logFailed;
    }

    public void setLogFailed(boolean logFailed) {
        this.logFailed = logFailed;
    }

    public long getSlowSqlThreshold() {
        return this.slowSqlThreshold;
    }

    public void setSlowSqlThreshold(long slowSqlThreshold) {
        this.slowSqlThreshold = slowSqlThreshold;
    }

    public Set<String> getDisconnectionSqlCodes() {
        Set<String> result = this.disconnectionSqlCodes;
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    @Override
    public String[] getDisconnectionSqlCodesAsArray() {
        Set<String> result = this.getDisconnectionSqlCodes();
        return result.toArray(new String[result.size()]);
    }

    @Override
    public long getBorrowedCount() {
        PoolingDataSource ds = this.dataSource;
        if (ds != null) {
            return ds.getBorrowedCount();
        }
        return 0L;
    }

    @Override
    public long getCreatedCount() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getCreatedCount();
    }

    @Override
    public long getReturnedCount() {
        PoolingDataSource ds = this.dataSource;
        if (ds != null) {
            return ds.getReturnedCount();
        }
        return 0L;
    }

    @Override
    public long getDestroyedCount() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getDestroyedCount();
    }

    @Override
    public long getDestroyedByBorrowValidationCount() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getDestroyedByBorrowValidationCount();
    }

    @Override
    public long getDestroyedByEvictorCount() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getDestroyedByEvictorCount();
    }

    @Override
    public long getConnectionLeakCount() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getConnectionLeakCount();
    }

    @Override
    public int getNumWaiters() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getNumWaiters();
    }

    @Override
    public long getMeanActiveTimeMillis() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getMeanActiveTimeMillis();
    }

    @Override
    public long getMeanBorrowWaitTimeMillis() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getMeanBorrowWaitTimeMillis();
    }

    @Override
    public long getMeanIdleTimeMillis() {
        if (this.connectionPool == null) {
            throw new UnsupportedOperationException("ConnectionPool has not been initialized.");
        }
        return this.connectionPool.getMeanIdleTimeMillis();
    }

    public void setDisconnectionSqlCodes(Collection<String> disconnectionSqlCodes) {
        if (disconnectionSqlCodes != null && disconnectionSqlCodes.size() > 0) {
            HashSet<String> newVal = null;
            for (String s : disconnectionSqlCodes) {
                if (s == null || s.trim().length() <= 0) continue;
                if (newVal == null) {
                    newVal = new HashSet<String>();
                }
                newVal.add(s);
            }
            this.disconnectionSqlCodes = newVal;
        } else {
            this.disconnectionSqlCodes = null;
        }
    }

    public void setFailAllConnection(boolean failAllConnection) {
        this.failAllConnection = failAllConnection;
    }

    public boolean isFailAllConnection() {
        return this.failAllConnection;
    }

    @Override
    public boolean getFastFailValidation() {
        return this.fastFailValidation;
    }

    public void setFastFailValidation(boolean fastFailValidation) {
        this.fastFailValidation = fastFailValidation;
    }

    public void setUsingTrace(boolean usingTrace) {
        this.usingTrace = usingTrace;
    }

    public boolean getUsingTrace() {
        return this.usingTrace;
    }

    public boolean isWrapStatement() {
        return this.wrapStatement;
    }

    public void setWrapStatement(boolean wrapStatement) {
        this.wrapStatement = wrapStatement;
    }

    public int getStandbySize() {
        return this.standbySize;
    }

    public void setStandbySize(int standbySize) {
        this.standbySize = standbySize;
    }

    public int getStandbyLevel() {
        return this.standbyLevel;
    }

    public void setStandbyLevel(int standbyLevel) {
        this.standbyLevel = standbyLevel;
    }

    public boolean isFairness() {
        return this.fairness;
    }

    public void setFairness(boolean fairness) {
        this.fairness = fairness;
    }

    public boolean isEnableSharingResources() {
        return this.enableSharingResources;
    }

    public void setEnableSharingResources(boolean enableSharingResources) {
        this.enableSharingResources = enableSharingResources;
    }

    public GenericObjectPool<PoolableConnection> getConnectionPool() {
        return this.connectionPool;
    }

    Properties getConnectionProperties() {
        return this.connectionProperties;
    }

    @Override
    public Connection getConnection() throws SQLException {
        Sharable resource;
        SharableResource sharableResource;
        if (Utils.IS_SECURITY_ENABLED) {
            PaGetConnection action = new PaGetConnection();
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException(e);
            }
        }
        DataSource createdDataSource = this.createDataSource();
        SharableResourceContext context = null;
        Connection con = null;
        ResourceKey resourceKey = new ResourceKey(this.name);
        resourceKey.setType(ResourceKey.RESOURCE_TYPE_DATASOURCE);
        if (this.enableSharingResources && !this.hasActiveTransactionContext() && (context = SharableResourceManager.getInstance().getShareResourceContext()) != null && (sharableResource = context.getResource((SharableKey)resourceKey)) != null && (resource = sharableResource.getResource()) instanceof Connection) {
            con = (Connection)resource;
        }
        if (con == null) {
            con = createdDataSource.getConnection();
            ExternalResoureManager.getInstance().addExternalResoure((Object)con);
            if (con instanceof DelegatingConnection) {
                ((DelegatingConnection)con).setResultSetCache(this.resultSetCache);
            }
            if (context != null) {
                DelegatingConnection delegating = (DelegatingConnection)con;
                delegating.setSharingInternal(true);
                resource = new SharableResource((SharableKey)resourceKey, (Sharable)delegating);
                context.enlistResource((SharableKey)resourceKey, (SharableResource)resource);
            }
        }
        return con;
    }

    @Override
    public Connection getConnection(String user, String pass) throws SQLException {
        Sharable resource;
        SharableResource sharableResource;
        if (!this.matchConnections) {
            throw new UnsupportedOperationException("Not supported when matchConnections property is false");
        }
        if (Utils.IS_SECURITY_ENABLED) {
            PaGetConnection action = new PaGetConnection();
            try {
                return AccessController.doPrivileged(action);
            }
            catch (PrivilegedActionException e) {
                Throwable cause = e.getCause();
                if (cause instanceof SQLException) {
                    throw (SQLException)cause;
                }
                throw new SQLException(e);
            }
        }
        DataSource createdDataSource = this.createDataSource();
        SharableResourceContext context = null;
        Connection con = null;
        ResourceKey resourceKey = new ResourceKey(this.name, user, this.password);
        resourceKey.setType(ResourceKey.RESOURCE_TYPE_DATASOURCE);
        if (this.enableSharingResources && !this.hasActiveTransactionContext() && (context = SharableResourceManager.getInstance().getShareResourceContext()) != null && (sharableResource = context.getResource((SharableKey)resourceKey)) != null && (resource = sharableResource.getResource()) instanceof Connection) {
            con = (Connection)resource;
        }
        if (con == null) {
            con = createdDataSource.getConnection(user, pass);
            ExternalResoureManager.getInstance().addExternalResoure((Object)con);
            if (con instanceof DelegatingConnection) {
                ((DelegatingConnection)con).setResultSetCache(this.resultSetCache);
            }
            if (context != null) {
                DelegatingConnection delegating = (DelegatingConnection)con;
                delegating.setSharingInternal(true);
                resource = new SharableResource((SharableKey)resourceKey, (Sharable)delegating);
                context.enlistResource((SharableKey)resourceKey, (SharableResource)resource);
            }
        }
        return con;
    }

    protected boolean hasActiveTransactionContext() throws SQLException {
        return false;
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        throw new UnsupportedOperationException("Not supported by BasicDataSource");
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.createDataSource().getLogWriter();
    }

    @Override
    public void setLoginTimeout(int loginTimeout) throws SQLException {
        if (this.dataSource != null) {
            this.dataSource.setLoginTimeout(loginTimeout);
        }
    }

    @Override
    public void setLogWriter(PrintWriter logWriter) throws SQLException {
        this.createDataSource().setLogWriter(logWriter);
        this.logWriter = logWriter;
    }

    public void setEnableLeakageRecovery(boolean enableLeakageRecovery) {
        this.enableLeakageRecovery = enableLeakageRecovery;
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedOnMaintenance(enableLeakageRecovery);
        this.abandonedConfig.setRemoveAbandonedOnBorrow(enableLeakageRecovery);
    }

    @Override
    public boolean getEnableLeakageRecovery() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedOnMaintenance();
        }
        return this.enableLeakageRecovery;
    }

    @Override
    public int getConnectionLeakTimeoutInSeconds() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getRemoveAbandonedTimeout();
        }
        return this.connectionLeakTimeoutInSeconds;
    }

    public void setConnectionLeakTimeoutInSeconds(int connectionLeakTimeoutInSeconds) {
        this.connectionLeakTimeoutInSeconds = connectionLeakTimeoutInSeconds;
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setRemoveAbandonedTimeout(connectionLeakTimeoutInSeconds);
    }

    @Override
    public boolean getLogAbandoned() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogAbandoned();
        }
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogAbandoned(logAbandoned);
    }

    public PrintWriter getAbandonedLogWriter() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getLogWriter();
        }
        return null;
    }

    public void setAbandonedLogWriter(PrintWriter logWriter) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setLogWriter(logWriter);
    }

    @Override
    public boolean getAbandonedUsageTracking() {
        if (this.abandonedConfig != null) {
            return this.abandonedConfig.getUseUsageTracking();
        }
        return false;
    }

    public void setAbandonedUsageTracking(boolean usageTracking) {
        if (this.abandonedConfig == null) {
            this.abandonedConfig = new AbandonedConfig();
        }
        this.abandonedConfig.setUseUsageTracking(usageTracking);
    }

    public void addConnectionProperty(String name, String value) {
        this.connectionProperties.put(name, value);
    }

    public void removeConnectionProperty(String name) {
        this.connectionProperties.remove(name);
    }

    public void setConnectionProperties(String connectionProperties) {
        if (connectionProperties == null) {
            throw new NullPointerException("connectionProperties is null");
        }
        String[] entries = connectionProperties.split(";");
        Properties properties = new Properties();
        for (String entry : entries) {
            if (entry.length() <= 0) continue;
            int index = entry.indexOf(61);
            if (index > 0) {
                String name = entry.substring(0, index);
                String value = entry.substring(index + 1);
                properties.setProperty(name, value);
                continue;
            }
            properties.setProperty(entry, "");
        }
        this.connectionProperties = properties;
    }

    @Override
    public synchronized void close() throws SQLException {
        if (this.registeredJmxName != null) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            if (mbs.isRegistered(this.registeredJmxName)) {
                try {
                    mbs.unregisterMBean(this.registeredJmxName);
                }
                catch (JMException e) {
                    log.warn((Object)("Failed to unregister the JMX name: " + this.registeredJmxName), (Throwable)e);
                }
            }
            this.registeredJmxName = null;
        }
        this.closed = true;
        GenericObjectPool<PoolableConnection> oldpool = this.connectionPool;
        this.connectionPool = null;
        this.dataSource = null;
        try {
            if (oldpool != null) {
                oldpool.close();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException(Utils.getMessage("pool.close.fail"), e);
        }
        if (this.netTimeoutExecutor instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor threadPoolExecutor = (ThreadPoolExecutor)this.netTimeoutExecutor;
            threadPoolExecutor.shutdown();
            try {
                if (!threadPoolExecutor.awaitTermination(1000L, TimeUnit.MILLISECONDS)) {
                    threadPoolExecutor.shutdownNow();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    @Override
    public synchronized boolean isClosed() {
        return this.closed;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("BasicDataSource is not a wrapper.");
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException();
    }

    public void invalidateConnection(Connection connection) throws IllegalStateException {
        PoolableConnection poolableConnection;
        if (connection == null) {
            return;
        }
        if (this.connectionPool == null) {
            throw new IllegalStateException("Cannot invalidate connection: ConnectionPool is null.");
        }
        try {
            poolableConnection = connection.unwrap(PoolableConnection.class);
            if (poolableConnection == null) {
                throw new IllegalStateException("Cannot invalidate connection: Connection is not a poolable connection.");
            }
        }
        catch (SQLException e) {
            throw new IllegalStateException("Cannot invalidate connection: Unwrapping poolable connection failed.", e);
        }
        try {
            connection.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.connectionPool.invalidateObject(poolableConnection);
        }
        catch (Exception e) {
            throw new IllegalStateException("Invalidating connection threw unexpected exception", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DataSource createDataSource() throws SQLException {
        if (this.closed) {
            throw new SQLException("Data source is closed");
        }
        if (this.dataSource != null) {
            return this.dataSource;
        }
        BasicDataSource basicDataSource = this;
        synchronized (basicDataSource) {
            PoolingDataSource newDataSource;
            PoolableConnectionFactory poolableConnectionFactory;
            if (this.dataSource != null) {
                return this.dataSource;
            }
            if (!this.createOnInitialize) {
                this.jmxRegister();
            }
            if (this.sqlTrace) {
                this.queryReport = new QueryReport(this.name, this.maxQueries, this.logSlow, this.logFailed, this.slowSqlThreshold);
            }
            ConnectionFactory driverConnectionFactory = this.createConnectionFactory();
            boolean success = false;
            try {
                poolableConnectionFactory = this.createPoolableConnectionFactory(driverConnectionFactory);
                poolableConnectionFactory.setPoolStatements(this.poolStatements);
                poolableConnectionFactory.setPoolPreparedStatements(this.poolPreparedStatements);
                poolableConnectionFactory.setMaxOpenPreparedStatements(this.statementCacheSize);
                poolableConnectionFactory.setQueryReporter(this.queryReport);
                success = true;
            }
            catch (SQLException se) {
                throw se;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new SQLException("Error creating connection factory", ex);
            }
            if (success) {
                this.createConnectionPool(poolableConnectionFactory);
            }
            success = false;
            try {
                newDataSource = this.createDataSourceInstance();
                newDataSource.setLogWriter(this.logWriter);
                success = true;
            }
            catch (SQLException se) {
                throw se;
            }
            catch (RuntimeException rte) {
                throw rte;
            }
            catch (Exception ex) {
                throw new SQLException("Error creating datasource", ex);
            }
            finally {
                if (!success) {
                    this.closeConnectionPool();
                }
            }
            try {
                for (int i = 0; i < this.initialPoolSize; ++i) {
                    this.connectionPool.addObject();
                }
            }
            catch (Exception e) {
                this.closeConnectionPool();
                throw new SQLException("Error preloading the connection pool", e);
            }
            this.startPoolMaintenance();
            this.dataSource = newDataSource;
            this.resultSetCache = BesJdbcCache.createInstance(this.url);
            return this.dataSource;
        }
    }

    protected Class loadDriverClass() throws ClassNotFoundException, SQLException {
        Class<?> driverFromCCL = null;
        try {
            driverFromCCL = this.driverClassLoader == null ? Class.forName(this.driverClassName) : Class.forName(this.driverClassName, true, this.driverClassLoader);
        }
        catch (ClassNotFoundException cnfe) {
            driverFromCCL = Thread.currentThread().getContextClassLoader().loadClass(this.driverClassName);
        }
        if (driverFromCCL != null && !Driver.class.isAssignableFrom(driverFromCCL) && !DataSource.class.isAssignableFrom(driverFromCCL)) {
            throw new SQLException("Class " + driverFromCCL.getCanonicalName() + " is not a javax.sql.DataSource or java.sql.Driver");
        }
        return driverFromCCL;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        String user;
        Driver driverToUse = this.driver;
        if (driverToUse == null) {
            Class driverFromCCL = null;
            if (this.driverClassName != null) {
                try {
                    driverFromCCL = this.loadDriverClass();
                }
                catch (Exception t) {
                    String message = "Cannot load JDBC driver class '" + this.driverClassName + "'";
                    this.logWriter.println(message);
                    t.printStackTrace(this.logWriter);
                    throw new SQLException(message, t);
                }
            }
            try {
                if (driverFromCCL == null) {
                    driverToUse = DriverManager.getDriver(this.url);
                } else {
                    driverToUse = (Driver)driverFromCCL.newInstance();
                    if (!driverToUse.acceptsURL(this.url)) {
                        throw new SQLException("No suitable driver", "08001");
                    }
                }
            }
            catch (Exception t) {
                String message = "Cannot create JDBC driver of class '" + (this.driverClassName != null ? this.driverClassName : "") + "' for connect URL '" + this.url + "'";
                this.logWriter.println(message);
                t.printStackTrace(this.logWriter);
                throw new SQLException(message, t);
            }
        }
        if ((user = this.username) != null) {
            this.connectionProperties.put("user", user);
        } else {
            this.log("DBCP DataSource configured without a 'username'");
        }
        String pwd = this.password;
        if (pwd != null) {
            this.connectionProperties.put("password", pwd);
        } else {
            this.log("DBCP DataSource configured without a 'password'");
        }
        DriverConnectionFactory driverConnectionFactory = new DriverConnectionFactory(driverToUse, this.url, this.connectionProperties);
        return driverConnectionFactory;
    }

    protected void createConnectionPool(PoolableConnectionFactory factory) {
        GenericObjectPoolConfig config = new GenericObjectPoolConfig();
        this.updateJmxName(config);
        if (this.standbySize > 0 && this.minIdle < this.standbySize * 2) {
            throw new RuntimeException("minIdle must be 2 times more than standby size when enabled level connection!");
        }
        if (this.standbyLevel < 2) {
            throw new RuntimeException("standby level must be no less than 2!");
        }
        config.setStandbySize(this.standbySize);
        config.setStandbyLevel(this.standbyLevel);
        config.setMaxTotal(this.maxPoolSize);
        config.setFairness(this.fairness);
        config.setJmxEnabled(this.registeredJmxName != null);
        GenericObjectPool<PoolableConnection> gop = this.abandonedConfig != null && this.abandonedConfig.getRemoveAbandonedTimeout() > 0 ? new GenericObjectPool<PoolableConnection>(factory, config, this.abandonedConfig, this.lifo) : new GenericObjectPool<PoolableConnection>(factory, config, this.lifo);
        gop.setName(this.name);
        gop.setMaxTotal(this.maxPoolSize);
        gop.setMaxIdle(this.maxIdle);
        gop.setMinIdle(this.minIdle);
        gop.setMaxWaitMillis(this.maxWaitTimeInMillis);
        gop.setTestOnCreate(this.testOnCreate);
        gop.setTestOnBorrow(this.testOnBorrow);
        gop.setTestOnReturn(this.testOnReturn);
        gop.setNumTestsPerEvictionRun(this.numTestsPerEvictionRun);
        if (this.maxEvictableIdleTimeout < 0L) {
            gop.setMaxEvictableIdleTimeMillis(-1L);
        } else {
            gop.setMaxEvictableIdleTimeMillis(this.maxEvictableIdleTimeout * 1000L);
        }
        if (this.idleTimeout < 0) {
            gop.setMinEvictableIdleTimeMillis(-1L);
        } else {
            gop.setMinEvictableIdleTimeMillis(this.idleTimeout * 1000);
        }
        gop.setTestWhileIdle(this.testWhileIdle);
        gop.setMatchConnections(this.matchConnections);
        gop.setLifo(this.lifo);
        gop.setSwallowedExceptionListener(new SwallowedExceptionLogger(log, this.logExpiredConnections));
        gop.setEvictionPolicyClassName(this.evictionPolicyClassName);
        gop.setMaxLifetimeMillis(this.getMaxConnectionAge() * 1000L);
        factory.setPool(gop);
        this.connectionPool = gop;
    }

    private void closeConnectionPool() {
        GenericObjectPool<PoolableConnection> oldpool = this.connectionPool;
        this.connectionPool = null;
        try {
            if (oldpool != null) {
                oldpool.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startPoolMaintenance() {
        if (this.connectionPool != null && this.timeBetweenEvictionRunsMillis > 0L) {
            this.connectionPool.setTimeBetweenEvictionRunsMillis(this.timeBetweenEvictionRunsMillis);
        }
    }

    protected PoolingDataSource createDataSourceInstance() throws SQLException {
        PoolingDataSource<PoolableConnection> pds = new PoolingDataSource<PoolableConnection>(this.connectionPool);
        pds.setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        return pds;
    }

    protected Executor getNetworkTimeoutExecutor(DataSource dataSource, String dsClassName, String jdbcUrl) {
        if (dsClassName != null && dsClassName.contains("Mysql") || jdbcUrl != null && jdbcUrl.contains("mysql") || dataSource != null && dataSource.getClass().getName().contains("Mysql")) {
            this.netTimeoutExecutor = new SynchronousExecutor();
        } else {
            String threadName = this.name == null || this.name.length() == 0 ? "gjc-network-timeout" : this.name + "-network-timeout";
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(threadName);
            ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newCachedThreadPool(threadFactory);
            executor.setKeepAliveTime(15L, TimeUnit.SECONDS);
            executor.allowCoreThreadTimeOut(true);
            this.netTimeoutExecutor = executor;
        }
        return this.netTimeoutExecutor;
    }

    protected PoolableConnectionFactory createPoolableConnectionFactory(ConnectionFactory driverConnectionFactory) throws SQLException {
        PoolableConnectionFactory connectionFactory = null;
        try {
            connectionFactory = new PoolableConnectionFactory(driverConnectionFactory, this.registeredJmxName);
            connectionFactory.setValidationQuery(this.validationQuery);
            connectionFactory.setValidationQueryTimeout(this.validationQueryTimeout);
            connectionFactory.setValidateAtmostPeriodInMilliSeconds(this.validateAtmostOncePeriodInSeconds * 1000);
            connectionFactory.setConnectionInitSql(this.connectionInitSqls);
            connectionFactory.setDefaultReadOnly(this.defaultReadOnly);
            connectionFactory.setDefaultAutoCommit(this.defaultAutoCommit);
            connectionFactory.setDefaultTransactionIsolation(this.defaultTransactionIsolation);
            connectionFactory.setDefaultCatalog(this.defaultCatalog);
            connectionFactory.setCacheState(this.cacheState);
            connectionFactory.setPoolPreparedStatements(this.poolPreparedStatements);
            connectionFactory.setMaxOpenPreparedStatements(this.statementCacheSize);
            connectionFactory.setPoolStatements(this.poolStatements);
            connectionFactory.setMaxConnLifetimeMillis(this.maxConnectionAge * 1000L);
            connectionFactory.setRollbackOnReturn(this.rollbackOnReturn);
            connectionFactory.setEnableAutoCommitOnReturn(this.enableAutoCommitOnReturn);
            if (this.statementTimeoutInSeconds > -1) {
                connectionFactory.setDefaultQueryTimeout(this.statementTimeoutInSeconds);
            }
            if (this.fetchSize > 0) {
                connectionFactory.setDefaultFetchSize(this.fetchSize);
            }
            connectionFactory.setUsingTrace(this.usingTrace);
            connectionFactory.setMatchConnections(this.matchConnections);
            connectionFactory.setFailAllConnection(this.failAllConnection);
            connectionFactory.setWrapStatement(this.wrapStatement);
            connectionFactory.setNetworkTimeoutExecutor(this.getNetworkTimeoutExecutor(this.dataSource, this.driverClassName, this.url));
            BasicDataSource.validateConnectionFactory(connectionFactory);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new SQLException("Cannot create PoolableConnectionFactory (" + e.getMessage() + ")", e);
        }
        return connectionFactory;
    }

    protected static void validateConnectionFactory(PoolableConnectionFactory connectionFactory) throws Exception {
        PoolableConnection conn = null;
        PooledObject<PoolableConnection> p = null;
        try {
            p = connectionFactory.makeObject();
            conn = p.getObject();
            connectionFactory.activateObject(p);
            connectionFactory.validateConnection(conn);
            connectionFactory.passivateObject(p);
        }
        finally {
            if (p != null) {
                connectionFactory.destroyObject(p);
            }
        }
    }

    protected void log(String message) {
        if (this.logWriter != null) {
            this.logWriter.println(message);
        }
    }

    private void jmxRegister() {
        ObjectName oname;
        if (this.registeredJmxName != null) {
            return;
        }
        String requestedName = this.getJmxName();
        if (requestedName == null) {
            return;
        }
        try {
            oname = new ObjectName(requestedName);
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)("The requested JMX name [" + requestedName + "] was not valid and will be ignored."));
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, oname);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            log.warn((Object)"Failed to complete JMX registration", (Throwable)e);
        }
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        String requestedName = this.getJmxName();
        if (requestedName != null) {
            try {
                this.registeredJmxName = new ObjectName(requestedName);
            }
            catch (MalformedObjectNameException e) {
                log.warn((Object)("The requested JMX name [" + requestedName + "] was not valid and will be ignored."));
            }
        }
        if (this.registeredJmxName == null) {
            this.registeredJmxName = name;
        }
        return this.registeredJmxName;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
    }

    public void unRegisterQueryReport() {
        this.queryReport.unRegister();
    }

    private void updateJmxName(GenericObjectPoolConfig config) {
        if (this.registeredJmxName == null) {
            return;
        }
        StringBuilder base = new StringBuilder(this.registeredJmxName.toString());
        base.append(",connectionpool=");
        config.setJmxNameBase(base.toString());
        config.setJmxNamePrefix("connections");
    }

    protected ObjectName getRegisteredJmxName() {
        return this.registeredJmxName;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    static {
        DriverManager.getDrivers();
        try {
            if (Utils.IS_SECURITY_ENABLED) {
                ClassLoader loader = BasicDataSource.class.getClassLoader();
                String dbcpPackageName = BasicDataSource.class.getPackage().getName();
                loader.loadClass(dbcpPackageName + ".BasicDataSource$PaGetConnection");
                loader.loadClass(dbcpPackageName + ".DelegatingDatabaseMetaData");
                loader.loadClass(dbcpPackageName + ".PoolingConnection$StatementType");
                String poolPackageName = PooledObject.class.getPackage().getName();
                loader.loadClass(poolPackageName + ".impl.LinkedBlockingDeque$Node");
                loader.loadClass(poolPackageName + ".impl.GenericKeyedObjectPool$ObjectDeque");
            }
        }
        catch (ClassNotFoundException cnfe) {
            throw new IllegalStateException("Unable to pre-load classes", cnfe);
        }
    }

    private class PaGetConnection
    implements PrivilegedExceptionAction<Connection> {
        private PaGetConnection() {
        }

        @Override
        public Connection run() throws SQLException {
            Connection con = BasicDataSource.this.createDataSource().getConnection();
            ExternalResoureManager.getInstance().addExternalResoure((Object)con);
            if (con instanceof DelegatingConnection) {
                ((DelegatingConnection)con).setResultSetCache(BasicDataSource.this.resultSetCache);
            }
            return con;
        }
    }

    private static class SynchronousExecutor
    implements Executor {
        private SynchronousExecutor() {
        }

        @Override
        public void execute(Runnable command) {
            try {
                command.run();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

