/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.ConnectionResult;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;

public class ConnectionPoolDataSourceConnectionFactory
implements ConnectionFactory {
    private final String _uname;
    private final String _passwd;
    private final ConnectionPoolDataSource _cpds;

    public ConnectionPoolDataSourceConnectionFactory(ConnectionPoolDataSource cpds) {
        this(cpds, null, null);
    }

    public ConnectionPoolDataSourceConnectionFactory(ConnectionPoolDataSource cpds, String uname, String passwd) {
        this._cpds = cpds;
        this._uname = uname;
        this._passwd = passwd;
    }

    @Override
    public ConnectionResult getConnectionResult() throws SQLException {
        PooledConnection pc = this._uname == null ? this._cpds.getPooledConnection() : this._cpds.getPooledConnection(this._uname, this._passwd);
        return this.initPCConnection(pc);
    }

    @Override
    public ConnectionResult getConnectionResult(String username, String password) throws SQLException {
        PooledConnection pc = this._cpds.getPooledConnection(username, password);
        return this.initPCConnection(pc);
    }

    private ConnectionResult initPCConnection(PooledConnection pc) throws SQLException {
        Connection connection = pc.getConnection();
        pc.addConnectionEventListener(new ConnectionEventListener(){

            @Override
            public void connectionClosed(ConnectionEvent event) {
                PooledConnection pc = (PooledConnection)event.getSource();
                pc.removeConnectionEventListener(this);
                try {
                    pc.close();
                }
                catch (SQLException e) {
                    System.err.println("Failed to close Cpds Connection.");
                    e.printStackTrace();
                }
            }

            @Override
            public void connectionErrorOccurred(ConnectionEvent event) {
                this.connectionClosed(event);
            }
        });
        return new ConnectionResult(pc, connection);
    }
}

