/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.spi.ConnectionFactory;
import com.bes.enterprise.gjc.spi.ConnectionResult;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Properties;

public class DriverManagerConnectionFactory
implements ConnectionFactory {
    private String _connectUri = null;
    private String _uname = null;
    private String _passwd = null;
    private Properties _props = null;

    public DriverManagerConnectionFactory(String connectUri, Properties props) {
        this._connectUri = connectUri;
        this._props = props;
    }

    public DriverManagerConnectionFactory(String connectUri, String uname, String passwd) {
        this._connectUri = connectUri;
        this._uname = uname;
        this._passwd = passwd;
    }

    @Override
    public ConnectionResult getConnectionResult() throws SQLException {
        if (null == this._props) {
            if (this._uname == null) {
                return new ConnectionResult(null, DriverManager.getConnection(this._connectUri));
            }
            return new ConnectionResult(null, DriverManager.getConnection(this._connectUri, this._uname, this._passwd));
        }
        return new ConnectionResult(null, DriverManager.getConnection(this._connectUri, this._props));
    }

    @Override
    public ConnectionResult getConnectionResult(String username, String password) throws SQLException {
        if (null == this._props) {
            return new ConnectionResult(null, DriverManager.getConnection(this._connectUri, username, password));
        }
        this._props.put("user", username);
        this._props.put("password", password);
        return new ConnectionResult(null, DriverManager.getConnection(this._connectUri, this._props));
    }

    static {
        DriverManager.getDrivers();
    }
}

