/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.pool.impl.GenericObjectPool;
import com.bes.enterprise.gjc.spi.ConnectionHolderStatementWrapper;
import com.bes.enterprise.gjc.spi.DelegatingConnection;
import com.bes.enterprise.gjc.spi.PoolableConnectionMXBean;
import com.bes.enterprise.gjc.spi.QueryReport;
import com.bes.enterprise.gjc.spi.Utils;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.lang.management.ManagementFactory;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.sql.Statement;
import java.util.Collection;
import java.util.concurrent.Executor;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

public class PoolableConnection
extends DelegatingConnection<Connection>
implements PoolableConnectionMXBean {
    protected static final Log log = LogFactory.getLog(PoolableConnection.class);
    private static final boolean debugConnection = Boolean.parseBoolean(System.getProperty("com.bes.enterprise.jdbc.debugConnection", "true"));
    private static final int closeNetworkTimeoutInMillis = Integer.parseInt(System.getProperty("com.bes.enterprise.jdbc.closeNetworkTimeoutInMillis", "5000"));
    private static MBeanServer MBEAN_SERVER = null;
    protected final GenericObjectPool<PoolableConnection> _pool;
    private final ObjectName _jmxName;
    private PreparedStatement validationPreparedStatement = null;
    private String lastValidationSql = null;
    private long lastValidated;
    private boolean _fatalSqlExceptionThrown = false;
    private final Collection<String> _disconnectionSqlCodes;
    private final boolean _fastFailValidation;
    private boolean failAllConnection;
    private boolean wrapStatement = true;
    private ConnectionHolderStatementWrapper statementWrapper;
    private QueryReport queryReport;
    protected final String name;
    protected volatile boolean reallyClosed = false;

    public PoolableConnection(String name, Connection conn, GenericObjectPool<PoolableConnection> pool, ObjectName jmxName, Collection<String> disconnectSqlCodes, boolean fastFailValidation, QueryReport queryReport) {
        super(conn);
        this.name = name;
        this._pool = pool;
        this._jmxName = jmxName;
        this._disconnectionSqlCodes = disconnectSqlCodes;
        this._fastFailValidation = fastFailValidation;
        this.queryReport = queryReport;
        if (jmxName != null) {
            try {
                MBEAN_SERVER.registerMBean(this, jmxName);
            }
            catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException jMException) {
                // empty catch block
            }
        }
        if (log.isInfoEnabled() && debugConnection) {
            if (this._pool == null) {
                log.info((Object)("Created one temporary connection with name " + name));
            } else {
                log.info((Object)("The pool " + this._pool.getName() + " created one connection with name " + name));
            }
        }
        this.statementWrapper = this.createStatementWrapper("com.bes.enterprise.gjc.spi.cache.resultset.ConnectionHolderStatementWrapperImpl");
    }

    public PoolableConnection(String name, Connection conn, GenericObjectPool<PoolableConnection> pool, ObjectName jmxName, QueryReport queryReport) {
        this(name, conn, pool, jmxName, null, false, queryReport);
    }

    private ConnectionHolderStatementWrapper createStatementWrapper(String className) {
        ConnectionHolderStatementWrapper wrapper = null;
        try {
            wrapper = (ConnectionHolderStatementWrapper)Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException ex) {
            log.warn((Object)"Unable to load statement wrapper object ", (Throwable)ex);
        }
        return wrapper;
    }

    @Override
    protected void passivate() throws SQLException {
        super.passivate();
        this.setClosedInternal(true);
    }

    @Override
    public boolean isClosed() throws SQLException {
        if (this.isClosedInternal()) {
            return true;
        }
        if (this.getDelegateInternal().isClosed()) {
            this.close();
            return true;
        }
        return false;
    }

    @Override
    public synchronized void close() throws SQLException {
        boolean isUnderlyingConectionClosed;
        if (this.isClosedInternal()) {
            return;
        }
        try {
            isUnderlyingConectionClosed = this.getDelegateInternal().isClosed();
        }
        catch (SQLException e) {
            try {
                this._pool.invalidateObject(this);
            }
            catch (IllegalStateException ise) {
                try {
                    this._pool.getFactory().destroyObject(this._pool.getObject(this));
                }
                catch (Exception ex) {
                    throw new SQLException("Cannot close underlying connection ", e);
                }
            }
            catch (Exception ise) {
                // empty catch block
            }
            throw new SQLException("Cannot close connection (isClosed check failed)", e);
        }
        if (isUnderlyingConectionClosed) {
            try {
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Underlying connection closed unexpectedly, close the logic connection with name " + this.name));
                }
                this._pool.invalidateObject(this);
            }
            catch (IllegalStateException e) {
                try {
                    this._pool.getFactory().destroyObject(this._pool.getObject(this));
                }
                catch (Exception ex) {
                    throw new SQLException("Cannot close underlying connection ", e);
                }
            }
            catch (Exception e) {
                throw new SQLException("Cannot close connection (invalidating pooled object failed)", e);
            }
        } else {
            try {
                this._pool.returnObject(this);
            }
            catch (IllegalStateException e) {
                if (log.isWarnEnabled()) {
                    log.warn((Object)e.getMessage());
                }
                try {
                    this._pool.getFactory().destroyObject(this._pool.getObject(this));
                }
                catch (Exception ex) {
                    throw new SQLException("Cannot close underlying connection ", e);
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new SQLException("Cannot close connection (return to pool failed)", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reallyClose(Executor netTimeoutExecutor, boolean isNetworkTimeoutSupported) throws SQLException {
        this.reallyClosed = true;
        if (this._jmxName != null) {
            try {
                MBEAN_SERVER.unregisterMBean(this._jmxName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException jMException) {
                // empty catch block
            }
        }
        if (this.validationPreparedStatement != null) {
            try {
                this.validationPreparedStatement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        try {
            this.setNetworkTimeoutIfNecessary(netTimeoutExecutor, closeNetworkTimeoutInMillis, isNetworkTimeoutSupported);
        }
        finally {
            super.closeInternal();
        }
        if (log.isInfoEnabled() && debugConnection) {
            if (this._pool == null) {
                log.info((Object)("Destroyed connection with name " + this.name));
            } else {
                log.info((Object)("The pool " + this._pool.getName() + " destroyed connection with name " + this.name));
            }
        }
    }

    @Override
    public String getToString() {
        return this.toString();
    }

    public void validate(String sql, int timeoutInSeconds, Executor executor, boolean isNetworkTimeoutSupported) throws SQLException {
        if (this._fastFailValidation && this._fatalSqlExceptionThrown) {
            throw new SQLException(Utils.getMessage("poolableConnection.validate.fastFail"));
        }
        if (sql == null || sql.length() == 0) {
            if (timeoutInSeconds < 0) {
                timeoutInSeconds = 0;
            }
            try {
                if (!this.isValid(timeoutInSeconds)) {
                    throw new SQLException("isValid() returned false");
                }
            }
            catch (AbstractMethodError e) {
                throw new IllegalArgumentException("The current driver does not support isValid operation, please specify the valid sql.");
            }
            return;
        }
        int networkTimeoutInMillis = 0;
        if (isNetworkTimeoutSupported) {
            networkTimeoutInMillis = this.getInnermostDelegate().getNetworkTimeout();
        }
        try {
            this.setNetworkTimeoutIfNecessary(executor, timeoutInSeconds * 1000, isNetworkTimeoutSupported);
            if (!sql.equals(this.lastValidationSql)) {
                this.lastValidationSql = sql;
                this.validationPreparedStatement = this.getInnermostDelegate().prepareStatement(sql);
            }
            if (timeoutInSeconds > 0) {
                this.validationPreparedStatement.setQueryTimeout(timeoutInSeconds);
            }
            try (ResultSet rs = this.validationPreparedStatement.executeQuery();){
                if (!rs.next()) {
                    throw new SQLException("validationQuery didn't return a row");
                }
            }
        }
        catch (Exception ex) {
            throw ex;
        }
        finally {
            this.setNetworkTimeoutIfNecessary(executor, networkTimeoutInMillis, isNetworkTimeoutSupported);
        }
    }

    public void setNetworkTimeoutIfNecessary(Executor executor, int timeOutInMillis, boolean isNetworkTimeoutSupported) throws SQLException {
        if (!isNetworkTimeoutSupported) {
            return;
        }
        this.getInnermostDelegate().setNetworkTimeout(executor, timeOutInMillis);
    }

    private boolean isDisconnectionSqlException(SQLException e) {
        boolean fatalException = false;
        if (e instanceof SQLRecoverableException) {
            return true;
        }
        String sqlState = e.getSQLState();
        if (sqlState != null) {
            boolean bl = this._disconnectionSqlCodes == null ? sqlState.startsWith("08") || Utils.DISCONNECTION_SQL_CODES.contains(sqlState) : (fatalException = this._disconnectionSqlCodes.contains(sqlState));
            if (!fatalException && e.getNextException() != null) {
                fatalException = this.isDisconnectionSqlException(e.getNextException());
            }
        }
        return fatalException;
    }

    @Override
    protected void handleException(SQLException e) throws SQLException {
        this._fatalSqlExceptionThrown |= this.isDisconnectionSqlException(e);
        if (this._fatalSqlExceptionThrown && this.failAllConnection) {
            this._pool.failAllConnections();
            throw e;
        }
        if (this._fatalSqlExceptionThrown && !this.failAllConnection) {
            this.getDelegateInternal().close();
            throw e;
        }
        super.handleException(e);
    }

    public long getLastValidated() {
        return this.lastValidated;
    }

    public void setLastValidated(long lastValidated) {
        this.lastValidated = lastValidated;
    }

    private Statement wrapperStatement(Statement stmt) {
        return this.statementWrapper.wrapperStatement(stmt, super.getResultSetCache());
    }

    public QueryReport getQueryReport() {
        return this.queryReport;
    }

    public void setQueryReport(QueryReport queryReport) {
        this.queryReport = queryReport;
    }

    private Statement sqlTraceStatement(Statement stmt) {
        if (this.queryReport != null) {
            return (Statement)this.queryReport.createStatement(new Object[0], stmt);
        }
        return stmt;
    }

    private PreparedStatement sqlTracePreparedStatement(PreparedStatement stmt, String sql) {
        if (this.queryReport != null) {
            return (PreparedStatement)this.queryReport.prepareStatement(new Object[]{sql}, stmt);
        }
        return stmt;
    }

    private CallableStatement sqlTraceCallableStatement(CallableStatement stmt, String sql) {
        if (this.queryReport != null) {
            return (CallableStatement)this.queryReport.prepareCall(new Object[]{sql}, stmt);
        }
        return stmt;
    }

    @Override
    public Statement createStatement() throws SQLException {
        Statement stmt = super.createStatement();
        stmt = this.wrapperStatement(stmt);
        return this.sqlTraceStatement(stmt);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        Statement stmt = super.createStatement(resultSetType, resultSetConcurrency);
        stmt = this.wrapperStatement(stmt);
        return this.sqlTraceStatement(stmt);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        Statement stmt = super.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        stmt = this.wrapperStatement(stmt);
        return this.sqlTraceStatement(stmt);
    }

    private PreparedStatement wrapperPreparedStatement(PreparedStatement pstmt, String sql) {
        return this.statementWrapper.wrapperPreparedStatement(pstmt, sql, super.getResultSetCache());
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        PreparedStatement pstmt = super.prepareStatement(sql);
        pstmt = this.wrapperPreparedStatement(pstmt, sql);
        return this.sqlTracePreparedStatement(pstmt, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        PreparedStatement pstmt = super.prepareStatement(sql, resultSetType, resultSetConcurrency);
        pstmt = this.wrapperPreparedStatement(pstmt, sql);
        return this.sqlTracePreparedStatement(pstmt, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        PreparedStatement pstmt = super.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        pstmt = this.wrapperPreparedStatement(pstmt, sql);
        return this.sqlTracePreparedStatement(pstmt, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        PreparedStatement pstmt = super.prepareStatement(sql, autoGeneratedKeys);
        pstmt = this.wrapperPreparedStatement(pstmt, sql);
        return this.sqlTracePreparedStatement(pstmt, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        PreparedStatement pstmt = super.prepareStatement(sql, columnIndexes);
        pstmt = this.wrapperPreparedStatement(pstmt, sql);
        return this.sqlTracePreparedStatement(pstmt, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        PreparedStatement pstmt = super.prepareStatement(sql, columnNames);
        pstmt = this.wrapperPreparedStatement(pstmt, sql);
        return this.sqlTracePreparedStatement(pstmt, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        CallableStatement stmt = super.prepareCall(sql);
        return this.sqlTraceCallableStatement(stmt, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        CallableStatement stmt = super.prepareCall(sql, resultSetType, resultSetConcurrency);
        return this.sqlTraceCallableStatement(stmt, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        CallableStatement stmt = super.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        return this.sqlTraceCallableStatement(stmt, sql);
    }

    public void setFailAllConnection(boolean failAllConnection) {
        this.failAllConnection = failAllConnection;
    }

    public boolean isFailAllConnection() {
        return this.failAllConnection;
    }

    public void setWrapStatement(boolean wrapStatement) {
        this.wrapStatement = wrapStatement;
    }

    public boolean isWrapStatement() {
        return this.wrapStatement;
    }

    static {
        try {
            MBEAN_SERVER = ManagementFactory.getPlatformMBeanServer();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

