/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.pool.ClockSource;
import com.bes.enterprise.gjc.spi.AbstractQueryReport;
import com.bes.enterprise.gjc.spi.QueryReportMXBean;
import com.bes.enterprise.gjc.spi.QueryStatsJmx;
import com.bes.enterprise.logging.internal.Log;
import com.bes.enterprise.logging.internal.LogFactory;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;

public class QueryReport
extends AbstractQueryReport
implements QueryReportMXBean {
    private static final ClockSource clockSource = ClockSource.INSTANCE;
    private static final Log log = LogFactory.getLog(AbstractQueryReport.class);
    protected volatile ConcurrentHashMap<String, QueryStats> queries = new ConcurrentHashMap();
    private String poolName;
    private transient ObjectName objectName;
    protected int maxQueries = 1000;
    protected boolean logSlow = false;
    protected boolean logFailed = false;
    protected final Comparator<QueryStats> queryStatsComparator = new QueryStatsComparator();

    public QueryReport() {
    }

    public QueryReport(String poolName, int maxQueries, boolean logSlow, boolean logFailed, long threshold) {
        this.poolName = poolName;
        this.maxQueries = maxQueries;
        this.logSlow = logSlow;
        this.logFailed = logFailed;
        this.threshold = threshold;
        this.jmxRegister();
    }

    public void jmxRegister() {
        if (this.poolName == null) {
            return;
        }
        try {
            this.objectName = new ObjectName("com.bes.enterprise.management:type=queryreports,name=" + this.poolName);
        }
        catch (MalformedObjectNameException e) {
            log.warn((Object)("The query report named [" + this.poolName + "] was not valid and will be ignored."));
            return;
        }
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        try {
            mbs.registerMBean(this, this.objectName);
        }
        catch (InstanceAlreadyExistsException | MBeanRegistrationException | NotCompliantMBeanException e) {
            log.warn((Object)"Failed to complete JMX registration ", (Throwable)e);
        }
    }

    public void unRegister() {
        if (this.objectName != null) {
            MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
            try {
                mbs.unregisterMBean(this.objectName);
            }
            catch (InstanceNotFoundException | MBeanRegistrationException e) {
                log.warn((Object)"Failed to complete JMX degistration ", (Throwable)e);
            }
        }
    }

    @Override
    public void prepareStatement(String sql) {
        QueryStats qs;
        if (this.maxQueries > 0 && (qs = this.getQueryStats(sql)) != null) {
            qs.prepare();
        }
    }

    @Override
    public void prepareCall(String sql) {
        QueryStats qs;
        if (this.maxQueries > 0 && (qs = this.getQueryStats(sql)) != null) {
            qs.prepare();
        }
    }

    @Override
    protected String reportFailedQuery(String query, Object[] args, String name, long start, Throwable t) {
        String sql = super.reportFailedQuery(query, args, name, start, t);
        if (this.maxQueries > 0) {
            long delta = clockSource.elapsedMillis(start);
            QueryStats qs = this.getQueryStats(sql);
            if (qs != null) {
                qs.failure();
                qs.add(delta, start);
            }
            if (this.isLogFailed() && log.isWarnEnabled()) {
                log.warn((Object)("Failed Query Report SQL=" + sql + "; time=" + delta + " ms;"));
            }
        }
        return sql;
    }

    @Override
    protected String reportQuery(String query, Object[] args, String name, long start, long delta) {
        QueryStats qs;
        String sql = super.reportQuery(query, args, name, start, delta);
        if (this.maxQueries > 0 && (qs = this.getQueryStats(sql)) != null) {
            qs.add(delta, start);
        }
        return sql;
    }

    @Override
    protected String reportSlowQuery(String query, Object[] args, String name, long start, long delta) {
        QueryStats qs;
        String sql = super.reportSlowQuery(query, args, name, start, delta);
        if (this.maxQueries > 0 && (qs = this.getQueryStats(sql)) != null) {
            qs.add(delta, start);
            if (this.isLogSlow() && log.isWarnEnabled()) {
                log.warn((Object)("Slow Query Report SQL=" + sql + "; time=" + delta + " ms;"));
            }
        }
        return sql;
    }

    protected QueryStats getQueryStats(String sql) {
        ConcurrentHashMap<String, QueryStats> queries;
        if (sql == null) {
            sql = "";
        }
        if ((queries = this.queries) == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Connection has already been closed or abandoned");
            }
            return null;
        }
        QueryStats qs = queries.get(sql);
        if (qs == null) {
            qs = new QueryStats(sql);
            if (queries.putIfAbsent(sql, qs) != null) {
                qs = queries.get(sql);
            } else if (queries.size() > this.maxQueries) {
                this.removeOldest(queries);
            }
        }
        return qs;
    }

    @Override
    public QueryStatsJmx getQueryStatCompositeData(String sql) {
        QueryStats queryStats = this.getQueryStats(sql);
        if (queryStats == null) {
            return null;
        }
        return new QueryStatsJmx(queryStats.getQuery(), queryStats.nrOfInvocations, queryStats.maxInvocationTime, queryStats.getMaxInvocationDate(), queryStats.minInvocationTime, queryStats.minInvocationDate, queryStats.getTotalInvocationTime(), queryStats.failures, queryStats.prepareCount, queryStats.lastInvocation);
    }

    @Override
    public List<QueryStatsJmx> getQueryStatCompositeDatas() {
        ArrayList<QueryStatsJmx> queryStatsJmxes = new ArrayList<QueryStatsJmx>();
        for (QueryStats queryStats : this.queries.values()) {
            queryStatsJmxes.add(new QueryStatsJmx(queryStats.getQuery(), queryStats.nrOfInvocations, queryStats.maxInvocationTime, queryStats.getMaxInvocationDate(), queryStats.minInvocationTime, queryStats.minInvocationDate, queryStats.getTotalInvocationTime(), queryStats.failures, queryStats.prepareCount, queryStats.lastInvocation));
        }
        return queryStatsJmxes;
    }

    protected void removeOldest(ConcurrentHashMap<String, QueryStats> queries) {
        ArrayList<QueryStats> list = new ArrayList<QueryStats>(queries.values());
        Collections.sort(list, this.queryStatsComparator);
        int removeIndex = 0;
        while (queries.size() > this.maxQueries) {
            String sql = list.get(removeIndex).getQuery();
            queries.remove(sql);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing slow query, capacity reached:" + sql));
            }
            ++removeIndex;
        }
    }

    public boolean isLogSlow() {
        return this.logSlow;
    }

    public void setLogSlow(boolean logSlow) {
        this.logSlow = logSlow;
    }

    public boolean isLogFailed() {
        return this.logFailed;
    }

    public void setLogFailed(boolean logFailed) {
        this.logFailed = logFailed;
    }

    public static class QueryStatsComparator
    implements Comparator<QueryStats> {
        @Override
        public int compare(QueryStats stats1, QueryStats stats2) {
            return Long.compare(QueryStatsComparator.handleZero(stats1.lastInvocation), QueryStatsComparator.handleZero(stats2.lastInvocation));
        }

        private static long handleZero(long value) {
            return value == 0L ? Long.MAX_VALUE : value;
        }
    }

    public static class QueryStats {
        static final String[] FIELD_NAMES = new String[]{"query", "nrOfInvocations", "maxInvocationTime", "maxInvocationDate", "minInvocationTime", "minInvocationDate", "totalInvocationTime", "failures", "prepareCount", "lastInvocation"};
        static final String[] FIELD_DESCRIPTIONS = new String[]{"The SQL query", "The number of query invocations, a call to executeXXX", "The longest time for this query in milliseconds", "The time and date for when the longest query took place", "The shortest time for this query in milliseconds", "The time and date for when the shortest query took place", "The total amount of milliseconds spent executing this query", "The number of failures for this query", "The number of times this query was prepared (prepareStatement/prepareCall)", "The date and time of the last invocation"};
        static final OpenType<?>[] FIELD_TYPES = new OpenType[]{SimpleType.STRING, SimpleType.INTEGER, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.LONG, SimpleType.INTEGER, SimpleType.LONG};
        private final String query;
        private volatile int nrOfInvocations;
        private volatile long maxInvocationTime = Long.MIN_VALUE;
        private volatile long maxInvocationDate;
        private volatile long minInvocationTime = Long.MAX_VALUE;
        private volatile long minInvocationDate;
        private volatile long totalInvocationTime;
        private volatile long failures;
        private volatile int prepareCount;
        private volatile long lastInvocation = 0L;

        public static String[] getFieldNames() {
            return FIELD_NAMES;
        }

        public static String[] getFieldDescriptions() {
            return FIELD_DESCRIPTIONS;
        }

        public static OpenType<?>[] getFieldTypes() {
            return FIELD_TYPES;
        }

        public String toString() {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
            StringBuilder buf = new StringBuilder("QueryStats[query:");
            buf.append(this.query);
            buf.append(", nrOfInvocations:");
            buf.append(this.nrOfInvocations);
            buf.append(", maxInvocationTime:");
            buf.append(this.maxInvocationTime);
            buf.append(", maxInvocationDate:");
            buf.append(sdf.format(new Date(this.maxInvocationDate)));
            buf.append(", minInvocationTime:");
            buf.append(this.minInvocationTime);
            buf.append(", minInvocationDate:");
            buf.append(sdf.format(new Date(this.minInvocationDate)));
            buf.append(", totalInvocationTime:");
            buf.append(this.totalInvocationTime);
            buf.append(", averageInvocationTime:");
            buf.append((float)this.totalInvocationTime / (float)this.nrOfInvocations);
            buf.append(", failures:");
            buf.append(this.failures);
            buf.append(", prepareCount:");
            buf.append(this.prepareCount);
            buf.append(']');
            return buf.toString();
        }

        public CompositeDataSupport getCompositeData(CompositeType type) throws OpenDataException {
            Object[] values = new Object[]{this.query, this.nrOfInvocations, this.maxInvocationTime, this.maxInvocationDate, this.minInvocationTime, this.minInvocationDate, this.totalInvocationTime, this.failures, this.prepareCount, this.lastInvocation};
            return new CompositeDataSupport(type, FIELD_NAMES, values);
        }

        public QueryStats(String query) {
            this.query = query;
        }

        public void prepare() {
            ++this.prepareCount;
        }

        public void add(long invocationTime, long now) {
            this.maxInvocationTime = Math.max(invocationTime, this.maxInvocationTime);
            if (this.maxInvocationTime == invocationTime) {
                this.maxInvocationDate = now;
            }
            this.minInvocationTime = Math.min(invocationTime, this.minInvocationTime);
            if (this.minInvocationTime == invocationTime) {
                this.minInvocationDate = now;
            }
            ++this.nrOfInvocations;
            this.totalInvocationTime += invocationTime;
            this.lastInvocation = now;
        }

        public void failure() {
            ++this.failures;
        }

        public String getQuery() {
            return this.query;
        }

        public int getNrOfInvocations() {
            return this.nrOfInvocations;
        }

        public long getMaxInvocationTime() {
            return this.maxInvocationTime;
        }

        public long getMaxInvocationDate() {
            return this.maxInvocationDate;
        }

        public long getMinInvocationTime() {
            return this.minInvocationTime;
        }

        public long getMinInvocationDate() {
            return this.minInvocationDate;
        }

        public long getTotalInvocationTime() {
            return this.totalInvocationTime;
        }

        public long getFailures() {
            return this.failures;
        }

        public int getPrepareCount() {
            return this.prepareCount;
        }

        public long getLastInvocation() {
            return this.lastInvocation;
        }

        public int hashCode() {
            return this.query.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof QueryStats) {
                QueryStats qs = (QueryStats)other;
                return qs.query.equals(this.query);
            }
            return false;
        }

        public boolean isOlderThan(QueryStats other) {
            return this.lastInvocation < other.lastInvocation;
        }
    }
}

