/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi;

import com.bes.enterprise.gjc.spi.DelegatingCallableStatement;
import com.bes.enterprise.gjc.spi.DelegatingPreparedStatement;
import com.bes.enterprise.gjc.spi.DelegatingStatement;
import com.bes.enterprise.gjc.spi.PoolingConnection;
import com.bes.enterprise.gjc.spi.base.CacheObjectKey;
import com.bes.enterprise.gjc.spi.base.datastructure.Cache;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;

public class StatementCacheManager {
    private Cache statementCache;
    private boolean statementCaching;
    private boolean prepareStatementCaching;
    private PoolingConnection conWrapper;

    public StatementCacheManager(PoolingConnection conWrapper, Cache statementCache, boolean prepareStatementCache, boolean statementCaching) {
        this.conWrapper = conWrapper;
        this.statementCache = statementCache;
        this.statementCaching = statementCaching;
        this.prepareStatementCaching = prepareStatementCache;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Statement cachedStatement() throws SQLException {
        if (!this.statementCaching) return this.conWrapper.cachedStatement(false);
        CacheObjectKey key = new CacheObjectKey(null, this.conWrapper.getCatalog(), "S");
        DelegatingStatement gs = (DelegatingStatement)this.statementCache.checkAndUpdateCache(key);
        if (gs == null) {
            gs = this.conWrapper.cachedStatement(true);
            gs.setBusy(true);
            this.statementCache.addToCache(key, gs, false);
            return gs;
        }
        if (this.isFree(gs)) {
            gs.setBusy(true);
            return gs;
        }
        DelegatingStatement gsw = this.conWrapper.cachedStatement(true);
        gsw.setBusy(true);
        this.statementCache.addToCache(key, gsw, false);
        return gsw;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Statement cachedStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.statementCaching) return this.conWrapper.cachedStatement(resultSetType, resultSetConcurrency, false);
        CacheObjectKey key = new CacheObjectKey(null, this.conWrapper.getCatalog(), resultSetType, resultSetConcurrency, "S");
        DelegatingStatement gs = (DelegatingStatement)this.statementCache.checkAndUpdateCache(key);
        if (gs == null) {
            gs = this.conWrapper.cachedStatement(resultSetType, resultSetConcurrency, true);
            gs.setBusy(true);
            this.statementCache.addToCache(key, gs, false);
            return gs;
        }
        if (this.isFree(gs)) {
            gs.setBusy(true);
            return gs;
        }
        DelegatingStatement gsw = this.conWrapper.cachedStatement(resultSetType, resultSetConcurrency, true);
        gsw.setBusy(true);
        this.statementCache.addToCache(key, gsw, false);
        return gsw;
    }

    /*
     * Enabled aggressive block sorting
     */
    public Statement cachedStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.statementCaching) return this.conWrapper.cachedStatement(resultSetType, resultSetConcurrency, resultSetHoldability, false);
        CacheObjectKey key = new CacheObjectKey(null, this.conWrapper.getCatalog(), resultSetType, resultSetConcurrency, resultSetHoldability, "S");
        DelegatingStatement gs = (DelegatingStatement)this.statementCache.checkAndUpdateCache(key);
        if (gs == null) {
            gs = this.conWrapper.cachedStatement(resultSetType, resultSetConcurrency, resultSetHoldability, true);
            gs.setBusy(true);
            this.statementCache.addToCache(key, gs, false);
            return gs;
        }
        if (this.isFree(gs)) {
            gs.setBusy(true);
            return gs;
        }
        DelegatingStatement gsw = this.conWrapper.cachedStatement(resultSetType, resultSetConcurrency, resultSetHoldability, true);
        gsw.setBusy(true);
        this.statementCache.addToCache(key, gsw, false);
        return gsw;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), resultSetType, resultSetConcurrency, "PS");
        DelegatingPreparedStatement ps = (DelegatingPreparedStatement)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return this.conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, false);
            if (!ps.isValid()) {
                this.statementCache.purge(ps);
                ps = this.conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, true);
                ps.setBusy(true);
                this.statementCache.addToCache(key, ps, false);
                return ps;
            } else {
                ps.setBusy(true);
            }
            return ps;
        } else {
            ps = this.conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, true);
            ps.setBusy(true);
            this.statementCache.addToCache(key, ps, false);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(String sql) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.prepareCachedStatement(sql, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), "PS");
        DelegatingPreparedStatement ps = (DelegatingPreparedStatement)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return this.conWrapper.prepareCachedStatement(sql, false);
            if (!ps.isValid()) {
                this.statementCache.purge(ps);
                ps = this.conWrapper.prepareCachedStatement(sql, true);
                ps.setBusy(true);
                this.statementCache.addToCache(key, ps, false);
                return ps;
            } else {
                ps.setBusy(true);
            }
            return ps;
        } else {
            ps = this.conWrapper.prepareCachedStatement(sql, true);
            ps.setBusy(true);
            this.statementCache.addToCache(key, ps, false);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), resultSetType, resultSetConcurrency, resultSetHoldability, "PS");
        DelegatingPreparedStatement ps = (DelegatingPreparedStatement)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return this.conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
            if (!ps.isValid()) {
                this.statementCache.purge(ps);
                ps = this.conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
                ps.setBusy(true);
                this.statementCache.addToCache(key, ps, false);
                return ps;
            } else {
                ps.setBusy(true);
            }
            return ps;
        } else {
            ps = this.conWrapper.prepareCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
            this.statementCache.addToCache(key, ps, false);
            ps.setBusy(true);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(String sql, String[] columnNames) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.prepareCachedStatement(sql, columnNames, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), columnNames);
        DelegatingPreparedStatement ps = (DelegatingPreparedStatement)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return this.conWrapper.prepareCachedStatement(sql, columnNames, false);
            if (!ps.isValid()) {
                this.statementCache.purge(ps);
                ps = this.conWrapper.prepareCachedStatement(sql, columnNames, true);
                ps.setBusy(true);
                this.statementCache.addToCache(key, ps, false);
                return ps;
            } else {
                ps.setBusy(true);
            }
            return ps;
        } else {
            ps = this.conWrapper.prepareCachedStatement(sql, columnNames, true);
            this.statementCache.addToCache(key, ps, false);
            ps.setBusy(true);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(String sql, int[] columnIndexes) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.prepareCachedStatement(sql, columnIndexes, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), columnIndexes);
        DelegatingPreparedStatement ps = (DelegatingPreparedStatement)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return this.conWrapper.prepareCachedStatement(sql, columnIndexes, false);
            if (!ps.isValid()) {
                this.statementCache.purge(ps);
                ps = this.conWrapper.prepareCachedStatement(sql, columnIndexes, true);
                ps.setBusy(true);
                this.statementCache.addToCache(key, ps, false);
                return ps;
            } else {
                ps.setBusy(true);
            }
            return ps;
        } else {
            ps = this.conWrapper.prepareCachedStatement(sql, columnIndexes, true);
            this.statementCache.addToCache(key, ps, false);
            ps.setBusy(true);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PreparedStatement prepareCachedStatement(String sql, int autoGeneratedKeys) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.prepareCachedStatement(sql, autoGeneratedKeys, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), autoGeneratedKeys);
        DelegatingPreparedStatement ps = (DelegatingPreparedStatement)this.statementCache.checkAndUpdateCache(key);
        if (ps != null) {
            if (!this.isFree(ps)) return this.conWrapper.prepareCachedStatement(sql, autoGeneratedKeys, false);
            if (!ps.isValid()) {
                this.statementCache.purge(ps);
                ps = this.conWrapper.prepareCachedStatement(sql, autoGeneratedKeys, true);
                ps.setBusy(true);
                this.statementCache.addToCache(key, ps, false);
                return ps;
            } else {
                ps.setBusy(true);
            }
            return ps;
        } else {
            ps = this.conWrapper.prepareCachedStatement(sql, autoGeneratedKeys, true);
            this.statementCache.addToCache(key, ps, false);
            ps.setBusy(true);
        }
        return ps;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareCachedCallableStatement(String sql) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.callableCachedStatement(sql, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), "CS");
        DelegatingCallableStatement cs = (DelegatingCallableStatement)this.statementCache.checkAndUpdateCache(key);
        if (cs != null) {
            if (!this.isFree(cs)) return this.conWrapper.callableCachedStatement(sql, false);
            if (!cs.isValid()) {
                this.statementCache.purge(cs);
                cs = this.conWrapper.callableCachedStatement(sql, true);
                cs.setBusy(true);
                this.statementCache.addToCache(key, cs, false);
                return cs;
            } else {
                cs.setBusy(true);
            }
            return cs;
        } else {
            cs = this.conWrapper.callableCachedStatement(sql, true);
            this.statementCache.addToCache(key, cs, false);
            cs.setBusy(true);
        }
        return cs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareCachedCallableStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), resultSetType, resultSetConcurrency, "CS");
        DelegatingCallableStatement cs = (DelegatingCallableStatement)this.statementCache.checkAndUpdateCache(key);
        if (cs != null) {
            if (!this.isFree(cs)) return this.conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, false);
            if (!cs.isValid()) {
                this.statementCache.purge(cs);
                cs = this.conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, true);
                cs.setBusy(true);
                this.statementCache.addToCache(key, cs, false);
                return cs;
            } else {
                cs.setBusy(true);
            }
            return cs;
        } else {
            cs = this.conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, true);
            this.statementCache.addToCache(key, cs, false);
            cs.setBusy(true);
        }
        return cs;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CallableStatement prepareCachedCallableStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (!this.prepareStatementCaching) return this.conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
        CacheObjectKey key = new CacheObjectKey(sql, this.conWrapper.getCatalog(), resultSetType, resultSetConcurrency, resultSetHoldability, "CS");
        DelegatingCallableStatement cs = (DelegatingCallableStatement)this.statementCache.checkAndUpdateCache(key);
        if (cs != null) {
            if (!this.isFree(cs)) return this.conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, false);
            if (!cs.isValid()) {
                this.statementCache.purge(cs);
                cs = this.conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
                cs.setBusy(true);
                this.statementCache.addToCache(key, cs, false);
                return cs;
            } else {
                cs.setBusy(true);
            }
            return cs;
        } else {
            cs = this.conWrapper.callableCachedStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability, true);
            this.statementCache.addToCache(key, cs, false);
            cs.setBusy(true);
        }
        return cs;
    }

    boolean isFree(DelegatingPreparedStatement cachedps) throws SQLException {
        return !cachedps.isBusy();
    }

    boolean isFree(DelegatingCallableStatement cachedstmt) throws SQLException {
        return !cachedstmt.isBusy();
    }

    boolean isFree(DelegatingStatement cachedstmt) throws SQLException {
        return !cachedstmt.isBusy();
    }

    public void close() {
        if (this.statementCache != null) {
            this.statementCache.flushCache();
        }
    }
}

