/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.base.datastructure;

import com.bes.enterprise.gjc.spi.DelegatingStatement;
import com.bes.enterprise.gjc.spi.base.CacheObjectKey;
import com.bes.enterprise.gjc.spi.base.datastructure.Cache;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LRUCacheImpl
implements Cache {
    private final Map<CacheObjectKey, CacheEntry> list;
    private final int maxSize;
    protected static final Logger _logger = Logger.getLogger(LRUCacheImpl.class.getName());

    public LRUCacheImpl(int maxSize) {
        this.maxSize = maxSize;
        this.list = new LinkedHashMap<CacheObjectKey, CacheEntry>();
    }

    @Override
    public Object checkAndUpdateCache(CacheObjectKey key) {
        Object result = null;
        CacheEntry entry = this.list.get(key);
        if (entry != null) {
            result = entry.entryObj;
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.finest("Cache Hit");
            }
        } else if (_logger.isLoggable(Level.FINEST)) {
            _logger.finest("Cache Miss");
        }
        return result;
    }

    @Override
    public void addToCache(CacheObjectKey key, Object o, boolean force) {
        if (force || !this.list.containsKey(key)) {
            if (this.list.size() >= this.maxSize) {
                this.purge(false);
            }
            CacheEntry entry = new CacheEntry(o);
            this.list.put(key, entry);
        } else if (this.list.containsKey(key)) {
            if (_logger.isLoggable(Level.WARNING)) {
                _logger.warning("Internal inconsistency: There are two statement with same key!");
            }
            DelegatingStatement ps = (DelegatingStatement)o;
            ps.setCached(false);
        }
    }

    @Override
    public void clearCache() {
        if (_logger.isLoggable(Level.FINE)) {
            _logger.fine("clearing objects in cache");
        }
        this.list.clear();
    }

    @Override
    public void flushCache() {
        while (this.list.size() != 0) {
            this.purge(true);
        }
    }

    @Override
    public void purge(boolean force) {
        block3: {
            Iterator<Map.Entry<CacheObjectKey, CacheEntry>> iterator = this.list.entrySet().iterator();
            if (!iterator.hasNext()) break block3;
            Map.Entry<CacheObjectKey, CacheEntry> next = iterator.next();
            CacheEntry entry = next.getValue();
            try {
                DelegatingStatement ps = (DelegatingStatement)entry.entryObj;
                ps.setCached(false);
                if (force || !ps.isBusy()) {
                    ps.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            iterator.remove();
        }
    }

    @Override
    public void purge(Object obj) {
        block4: {
            DelegatingStatement tmpPS = (DelegatingStatement)obj;
            Iterator<Map.Entry<CacheObjectKey, CacheEntry>> iterator = this.list.entrySet().iterator();
            if (!iterator.hasNext()) break block4;
            Map.Entry<CacheObjectKey, CacheEntry> next = iterator.next();
            CacheEntry entry = next.getValue();
            try {
                DelegatingStatement ps = (DelegatingStatement)entry.entryObj;
                if (ps.equals(tmpPS)) {
                    if (_logger.isLoggable(Level.FINEST)) {
                        _logger.log(Level.FINEST, "Purging an entry from cache");
                    }
                    ps.setCached(false);
                    ps.close();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            iterator.remove();
        }
    }

    @Override
    public int getSize() {
        return this.list.size();
    }

    public static class CacheEntry {
        private final Object entryObj;

        public CacheEntry(Object o) {
            this.entryObj = o;
        }
    }
}

