/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache;

import com.bes.enterprise.gjc.spi.Constants;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheValidSqlParse {
    private static List<String> oracle = Arrays.asList("sysdate", "sys_guid()", "dbms_random");
    private static List<String> mysql = Arrays.asList("now()", "uuid()", "uuid_short()", "rand()", "current_date()", "connection_id()", "current_time()", "current_timestamp()", "curtime()", "found_rows()", "last_insert_id()", "sysdate()");
    private static List<String> sqlserver = Arrays.asList("getdate()", "newid()", "rand()");
    private static Map<String, String> invalidSqlDict = new HashMap<String, String>();
    private String sql;

    public CacheValidSqlParse(String sql) {
        this.sql = sql;
    }

    public boolean cacheValid() {
        if (this.sql != null) {
            String[] words = this.sql.split("[\\s]+|\\.");
            for (int i = 0; i < words.length; ++i) {
                String word = words[i].toUpperCase();
                if (!invalidSqlDict.containsKey(word)) continue;
                return false;
            }
        }
        return true;
    }

    static {
        for (String str : oracle) {
            invalidSqlDict.put(str.toUpperCase(), str);
        }
        for (String str : mysql) {
            invalidSqlDict.put(str.toUpperCase(), str);
        }
        for (String str : sqlserver) {
            invalidSqlDict.put(str.toUpperCase(), str);
        }
        String words = Constants.RESULT_SET_CACHE_INVALID_WORDS;
        if (words != null) {
            for (String str : words.split(",")) {
                invalidSqlDict.put(str.toUpperCase(), str);
            }
        }
    }
}

