/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.decorators;

import com.bes.enterprise.gjc.spi.cache.Cache;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.concurrent.locks.ReadWriteLock;

public class WeakCache
implements Cache {
    private final ReferenceQueue<Object> queueOfGarbageCollectedEntries;
    private final Cache delegate;

    public WeakCache(Cache delegate) {
        this.delegate = delegate;
        this.queueOfGarbageCollectedEntries = new ReferenceQueue();
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public int getSize() {
        return this.delegate.getSize();
    }

    @Override
    public void putObject(Object key, Object value) {
        this.removeGarbageCollectedItems();
        this.delegate.putObject(key, new WeakEntry(key, value, this.queueOfGarbageCollectedEntries));
    }

    @Override
    public Object getObject(Object key) {
        Object result = null;
        WeakReference softReference = (WeakReference)this.delegate.getObject(key);
        if (softReference != null) {
            result = softReference.get();
        }
        return result;
    }

    @Override
    public Object removeObject(Object key) {
        this.removeGarbageCollectedItems();
        return this.delegate.removeObject(key);
    }

    @Override
    public void clear() {
        this.removeGarbageCollectedItems();
        this.delegate.clear();
    }

    @Override
    public ReadWriteLock getReadWriteLock() {
        return this.delegate.getReadWriteLock();
    }

    private void removeGarbageCollectedItems() {
        WeakEntry sv;
        while ((sv = (WeakEntry)this.queueOfGarbageCollectedEntries.poll()) != null) {
            this.delegate.removeObject(sv.key);
        }
    }

    @Override
    public void clearCatalog(String catalog) {
        this.delegate.clearCatalog(catalog);
    }

    private static class WeakEntry
    extends WeakReference<Object> {
        private final Object key;

        private WeakEntry(Object key, Object value, ReferenceQueue<Object> garbageCollectionQueue) {
            super(value, garbageCollectionQueue);
            this.key = key;
        }
    }
}

