/*
 * Decompiled with CFR 0.152.
 */
package com.bes.enterprise.gjc.spi.cache.resultset;

import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CacheResultSetMetaData
implements ResultSetMetaData {
    protected ResultSetMetaData resultSetMetaData;
    private Map<String, Integer> colDict = new HashMap<String, Integer>();
    protected List<Map<String, Object>> data;

    public CacheResultSetMetaData(ResultSetMetaData meta) throws SQLException {
        this.resultSetMetaData = meta;
        final int colNum = meta.getColumnCount();
        this.data = new ArrayList<Map<String, Object>>(){

            @Override
            public Map<String, Object> get(int index) {
                if (index <= 0 || index > colNum) {
                    throw new RuntimeException("java.sql.SQLException: \u65e0\u6548\u7684\u5217\u7d22\u5f15: getValidColumnIndex");
                }
                return (Map)super.get(index);
            }
        };
        this.data.add(null);
        for (int i = 1; i <= colNum; ++i) {
            this.colDict.put(meta.getColumnLabel(i).toLowerCase(), i);
            HashMap<String, Object> colInfo = new HashMap<String, Object>();
            colInfo.put("getCatalogName", meta.getCatalogName(i));
            colInfo.put("getColumnClassName", meta.getColumnClassName(i));
            colInfo.put("getColumnDisplaySize", meta.getColumnDisplaySize(i));
            colInfo.put("getColumnLabel", meta.getColumnLabel(i).toLowerCase());
            colInfo.put("getColumnName", meta.getColumnName(i));
            colInfo.put("getColumnType", meta.getColumnType(i));
            colInfo.put("getColumnTypeName", meta.getColumnTypeName(i));
            colInfo.put("getPrecision", meta.getPrecision(i));
            colInfo.put("getScale", meta.getScale(i));
            colInfo.put("getSchemaName", meta.getSchemaName(i));
            colInfo.put("getTableName", meta.getTableName(i));
            colInfo.put("isAutoIncrement", meta.isAutoIncrement(i));
            colInfo.put("isCaseSensitive", meta.isCaseSensitive(i));
            colInfo.put("isCurrency", meta.isCurrency(i));
            colInfo.put("isDefinitelyWritable", meta.isDefinitelyWritable(i));
            colInfo.put("isNullable", meta.isNullable(i));
            colInfo.put("isReadOnly", meta.isReadOnly(i));
            colInfo.put("isSearchable", meta.isSearchable(i));
            colInfo.put("isSigned", meta.isSigned(i));
            colInfo.put("isWritable", meta.isWritable(i));
            this.data.add(colInfo);
        }
    }

    public int getColumnIndex(String colName) {
        if (!this.colDict.containsKey(colName.toLowerCase())) {
            throw new RuntimeException("There is no column named : " + colName);
        }
        return this.colDict.get(colName.toLowerCase());
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return (String)this.data.get(column).get("getCatalogName");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return (String)this.data.get(column).get("getColumnClassName");
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.data.size() - 1;
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return (Integer)this.data.get(column).get("getColumnDisplaySize");
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return (String)this.data.get(column).get("getColumnLabel");
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return (String)this.data.get(column).get("getColumnName");
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return (Integer)this.data.get(column).get("getColumnType");
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return (String)this.data.get(column).get("getColumnTypeName");
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        return (Integer)this.data.get(column).get("getPrecision");
    }

    @Override
    public int getScale(int column) throws SQLException {
        return (Integer)this.data.get(column).get("getScale");
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return (String)this.data.get(column).get("getSchemaName");
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return (String)this.data.get(column).get("getTableName");
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return (Boolean)this.data.get(column).get("isAutoIncrement");
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return (Boolean)this.data.get(column).get("isCaseSensitive");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return (Boolean)this.data.get(column).get("isCurrency");
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return (Boolean)this.data.get(column).get("isDefinitelyWritable");
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return (Integer)this.data.get(column).get("isNullable");
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return (Boolean)this.data.get(column).get("isReadOnly");
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return (Boolean)this.data.get(column).get("isSearchable");
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return (Boolean)this.data.get(column).get("isSigned");
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return (Boolean)this.data.get(column).get("isWritable");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return this.resultSetMetaData.unwrap(iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return this.resultSetMetaData.isWrapperFor(iface);
    }
}

